/**
 * MCS Media Computer Software
 * Copyright 2012 by Wilfried Klaas
 * Project: MCSUtils
 * File: ManagedProperty.java
 * EMail: W.Klaas@gmx.de
 * Created: 14.03.2012 Willie
 */

package de.mcs.utils.event;

import java.util.List;

import de.mcs.utils.event.CallbackList.ListCallback;
import de.mcs.utils.event.CallbackList.Operation;

/**
 * @author Willie
 *
 */
public class ManagedProperty<E> implements ListCallback {

  public class ManagedEvent extends AbstractEvent {

    ManagedEvent(String name) {
      super(name);
    }

  }

  private E value;
  private Delegate delegate;
  private ManagedEvent event;
  private boolean fireEventActive;

  public ManagedProperty(String name, Delegate delegate, E initialValue) {
    this.value = initialValue;
    this.delegate = delegate;
    this.fireEventActive = true;
    this.event = new ManagedEvent(name);
    delegate.registerEvent(event);
    if (value instanceof List) {
      List<E> initialList = (List<E>) value;
      CallbackList<E> list = new CallbackList<E>(initialList);
      list.addCallback(this);
      value = (E) list;
    }
  }

  public void setValue(E newValue) {
    setValue(newValue, true);
  }

  public void setValue(E newValue, boolean fireEvent) {
    if (value != null) {
      if (!value.equals(newValue)) {
        E oldValue = value;
        value = newValue;
        if (fireEvent) {
          delegate.fireEvent(event, new Object[] { oldValue, newValue });
        }
      }
    } else if (newValue != null) {
      value = newValue;
      if (fireEvent) {
        delegate.fireEvent(event, new Object[] { value, newValue });
      }
    }
  }

  public void fireEvent() {
    if (fireEventActive) {
      delegate.fireEvent(event, new Object[] { value, value });
    }
  }

  public E getValue() {
    return value;
  }

  public void registerListener(EventListener listener) {
    delegate.registerListener(event, listener);
  }

  public void unregisterListener(EventListener listener) {
    delegate.unregisterListener(event, listener);
  }

  @Override
  public void handle(Operation operation) {
    if (fireEventActive) {
      delegate.fireEvent(event, new Object[] { operation.name() });
    }
  }

  public void setFireEvents(boolean value) {
    this.fireEventActive = value;
  }

  public boolean isFireEvents() {
    return this.fireEventActive;
  }
}
