/**
 * MCS Media Computer Software
 * Copyright 2012 by Wilfried Klaas
 * Project: SmallArchivePivotGUI
 * File: EventFactory.java
 * EMail: W.Klaas@gmx.de
 * Created: 11.03.2012 Willie
 */

package de.mcs.utils.event;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author Willie
 *
 */
public class EventFactory {

  private static EventFactory instance = new EventFactory();
  private Map<String, List<WeakReference<EventListener>>> events;;
  private List<WeakReference<EventListener>> generalListeners;

  public EventFactory() {
    this.events = new HashMap<String, List<WeakReference<EventListener>>>();
    this.generalListeners = new ArrayList<WeakReference<EventListener>>();
  }

  public void registerEvent(Event event) {
    synchronized (events) {
      if (!events.containsKey(event.getName())) {
        events.put(event.getName(), new ArrayList<WeakReference<EventListener>>());
      }
    }
  }

  public void registerListener(Event event, EventListener eventListener) {
    List<WeakReference<EventListener>> list = null;
    synchronized (events) {
      if (events.containsKey(event.getName())) {
        list = events.get(event.getName());
      }
    }
    if (list != null) {
      synchronized (list) {
        for (Iterator<WeakReference<EventListener>> iter = list.iterator(); iter.hasNext();) {
          WeakReference<EventListener> listener = iter.next();
          if (listener.isEnqueued()) {
            iter.remove();
          } else {
            if (eventListener.equals(listener.get())) {
              return;
            }
          }
        }
        WeakReference<EventListener> weakEventListener = new WeakReference<EventListener>(eventListener);
        list.add(weakEventListener);
      }
    }
  }

  public void unregisterListener(Event event, EventListener eventListener) {
    List<WeakReference<EventListener>> list = null;
    synchronized (events) {
      if (events.containsKey(event.getName())) {
        list = events.get(event.getName());
      }
    }
    if (list != null) {
      synchronized (list) {
        for (Iterator<WeakReference<EventListener>> iter = list.iterator(); iter.hasNext();) {
          WeakReference<EventListener> listener = iter.next();
          if (listener.isEnqueued()) {
            iter.remove();
          } else {
            if (eventListener.equals(listener.get())) {
              iter.remove();
            }
          }
        }
      }
    }
  }

  public void fireEvent(Event event, Object... data) {
    List<WeakReference<EventListener>> list = null;
    synchronized (events) {
      if (events.containsKey(event.getName())) {
        list = events.get(event.getName());
      }
    }
    if (list != null) {
      synchronized (list) {
        for (Iterator<WeakReference<EventListener>> iter = list.iterator(); iter.hasNext();) {
          WeakReference<EventListener> weakListener = iter.next();
          if (weakListener.isEnqueued()) {
            iter.remove();
          } else if (weakListener.get() == null) {
            iter.remove();
          } else {
            weakListener.get().handle(event.getName(), data);
          }
        }
      }
    }
    synchronized (generalListeners) {
      for (Iterator<WeakReference<EventListener>> iter = generalListeners.iterator(); iter.hasNext();) {
        WeakReference<EventListener> weakListener = iter.next();
        if (weakListener.isEnqueued()) {
          iter.remove();
        } else if (weakListener.get() == null) {
          iter.remove();
        } else {
          weakListener.get().handle(event.getName(), data);
        }
      }
    }
  }

  public boolean isEventRegistered(Event event1) {
    return events.containsKey(event1.getName());
  }

  public boolean isListenerRegistered(Event event, EventListener eventListener) {
    List<WeakReference<EventListener>> list = null;
    synchronized (events) {
      if (events.containsKey(event.getName())) {
        list = events.get(event.getName());
      }
    }
    if (list != null) {
      synchronized (list) {
        for (Iterator<WeakReference<EventListener>> iter = list.iterator(); iter.hasNext();) {
          WeakReference<EventListener> listener = iter.next();
          if (listener.isEnqueued()) {
            iter.remove();
          } else {
            if (eventListener.equals(listener.get())) {
              return true;
            }
          }
        }
      }
    }
    return false;
  }

  public static EventFactory getInstance() {
    return instance;
  }

  public void registerGeneralListener(EventListener eventListener) {
    synchronized (generalListeners) {
      for (Iterator<WeakReference<EventListener>> iter = generalListeners.iterator(); iter.hasNext();) {
        WeakReference<EventListener> listener = iter.next();
        if (listener.isEnqueued()) {
          iter.remove();
        } else {
          if (eventListener.equals(listener.get())) {
            return;
          }
        }
      }
      WeakReference<EventListener> weakEventListener = new WeakReference<EventListener>(eventListener);
      generalListeners.add(weakEventListener);
    }
  }

  public void unregisterGeneralListener(EventListener eventListener) {
    synchronized (generalListeners) {
      for (Iterator<WeakReference<EventListener>> iter = generalListeners.iterator(); iter.hasNext();) {
        WeakReference<EventListener> listener = iter.next();
        if (listener.isEnqueued()) {
          iter.remove();
        } else {
          if (eventListener.equals(listener.get())) {
            iter.remove();
          }
        }
      }
    }
  }

}
