/*
 * MCS Media Computer Software Copyright (c) 2005 by MCS
 * -------------------------------------- Created on 16.01.2004 by w.klaas
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package de.mcs.utils.codecs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

/**
 * Decode a BASE64 encoded input stream to some output stream. This class
 * implements BASE64 decoding, as specified in the <a
 * href="http://ds.internic.net/rfc/rfc1521.txt">MIME specification </a>. see
 * org.w3c.tools.codec.Base64Encoder This class is a modified version based on
 * code obtained from the w3 consortium website, which is subject to their
 * generic copyright notice:
 * <dl>
 * <dd><a href="http://www.w3.org/Consortium/Legal/">Copyright </a>�
 * [$date-of-software] <a HREF="http://www.w3.org/">World Wide Web Consortium
 * </a>, ( <a HREF="http://www.lcs.mit.edu/">Massachusetts Institute of
 * Technology </a>, <a HREF="http://www.inria.fr/">Institut National de
 * Recherche en Informatique et en Automatique </a>, <a
 * HREF="http://www.keio.ac.jp/">Keio University </a>). All Rights Reserved.
 * This program is distributed under the <a
 * HREF="http://www.w3.org/Consortium/Legal/copyright-software-19980720.html">W3C's
 * Software Intellectual Property License </a>. This program is distributed in
 * the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * W3C License <a
 * href="http://www.w3.org/Consortium/Legal/">http://www.w3.org/Consortium/Legal/
 * </a> for more details.</dd>
 * </dl>
 * 
 * @version $Revision: 1.1 $
 * @deprecated please use the base64 class.
 */
public class Base64Decoder {
  /** Größe des puffers. */
  private static final int BUFFER_SIZE = 1024;

  /** encoding. */
  private String encoding = null;

  /** Field in. */
  private InputStream in = null;

  /** Field out. */
  private OutputStream out = null;

  /** Field stringp. */
  private boolean stringp = false;

  // private void printHex(int x) {
  // int h = (x & 0xf0) >> 4;
  // int l = (x & 0x0f);
  // System.out.print(
  // (new Character((char) ((h > 9) ? 'A' + h - 10 : '0' + h))).toString()
  // + (new Character((char) ((l > 9) ? 'A' + l - 10 : '0' + l))).toString());
  // }

  // private void printHex(byte buf[], int off, int len) {
  // while (off < len) {
  // printHex(buf[off++]);
  // System.out.print(" ");
  // }
  // System.out.println("");
  // }

  // private void printHex(String s) {
  // byte bytes[];
  // try {
  // bytes = s.getBytes("ISO-8859-1");
  // }
  // catch (UnsupportedEncodingException ex) {
  // throw new RuntimeException(
  // this.getClass().getName() + "[printHex] Unable to convert" + "properly
  // char to bytes");
  // }
  // printHex(bytes, 0, bytes.length);
  // }

  /**
   * decode mime string to byte array.
   * 
   * @param string
   *            the string to decode
   * @return byte[]
   * @throws Exception
   *             if something goes wrong
   */
  public static byte[] decode(final String string) throws Exception {
    ByteArrayInputStream bin = new ByteArrayInputStream(string.getBytes());
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    Base64Decoder myDecode = new Base64Decoder(bin, bout);
    myDecode.process();
    return bout.toByteArray();
  }

  /**
   * @param buf
   *            der Puffer
   * @param off
   *            der Offset
   * @return int das Zeichen
   */
  private int get1(final byte[] buf, final int off) {
    return ((buf[off] & 0x3f) << 2) | ((buf[off + 1] & 0x30) >>> 4);
  }

  /**
   * @param buf
   *            der Puffer
   * @param off
   *            der Offset
   * @return int das Zeichen
   */
  private int get2(final byte[] buf, final int off) {
    return ((buf[off + 1] & 0x0f) << 4) | ((buf[off + 2] & 0x3c) >>> 2);
  }

  /**
   * @param buf
   *            der Puffer
   * @param off
   *            der Offset
   * @return int das Zeichen
   */
  private int get3(final byte[] buf, final int off) {
    return ((buf[off + 2] & 0x03) << 6) | (buf[off + 3] & 0x3f);
  }

  /**
   * check something.
   * 
   * @param ch
   *            input character
   * @return int
   */
  private int check(final int ch) {
    if ((ch >= 'A') && (ch <= 'Z')) {
      return ch - 'A';
    } else if ((ch >= 'a') && (ch <= 'z')) {
      return ch - 'a' + 26;
    } else if ((ch >= '0') && (ch <= '9')) {
      return ch - '0' + 52;
    } else {
      switch (ch) {
      case '=':
        return 65;
      case '+':
        return 62;
      case '/':
        return 63;
      default:
        return -1;
      }
    }
  }

  /**
   * Do the actual decoding. Process the input stream by decoding it and
   * emiting the resulting bytes into the output stream. exception IOException
   * If the input or output stream accesses failed.
   * 
   * @exception Exception
   *                If the input stream is not compliant with the BASE64
   *                specification.
   */

  public final void process() throws Exception {
    byte[] buffer = new byte[BUFFER_SIZE];
    byte[] chunk = new byte[4];
    int got = -1;
    int ready = 0;

    fill: while ((got = in.read(buffer)) > 0) {
      int skiped = 0;
      while (skiped < got) {
        // Check for un-understood characters:
        while (ready < 4) {
          if (skiped >= got) {
            continue fill;
          }
          int ch = check(buffer[skiped++]);
          if (ch >= 0) {
            chunk[ready++] = (byte) ch;
          }
        }
        if (chunk[2] == 65) {
          out.write(get1(chunk, 0));
          return;
        } else if (chunk[3] == 65) {
          out.write(get1(chunk, 0));
          out.write(get2(chunk, 0));
          return;
        } else {
          out.write(get1(chunk, 0));
          out.write(get2(chunk, 0));
          out.write(get3(chunk, 0));
        }
        ready = 0;
      }
    }
    if (ready != 0) {
      throw new Exception("Invalid length.");
    }
    out.flush();
  }

  /**
   * Do the decoding, and return a String. This methods should be called when
   * the decoder is used in <em>String</em> mode. It decodes the input
   * string to an output string that is returned.
   * 
   * @return String exception RuntimeException If the object wasn't
   *         constructed to decode a String.
   */

  public final String processString() {
    if (!stringp) {
      throw new RuntimeException(this.getClass().getName() + "[processString]" + "invalid call (not a String)");
    }
    try {
      process();
    } catch (IOException e) {
      e.printStackTrace();
    } catch (Exception ex) {
      ex.printStackTrace();
    }
    String s;
    try {
      s = ((ByteArrayOutputStream) out).toString(encoding);
    } catch (Exception ex) {
      throw new RuntimeException(this.getClass().getName() + "[processString] Unable to convert"
          + "properly char to bytes");
    }
    return s;
  }

  /**
   * Constructor for Base64Decoder.
   * 
   * @param input
   *            String
   */
  public Base64Decoder(final String input) {
    this(input, null);
  }

  /**
   * Create a decoder to decode a String.
   * 
   * @param input
   *            The string to be decoded.
   * @param sEncoding
   *            String
   */

  public Base64Decoder(final String input, final String sEncoding) {
    byte[] bytes;
    String myEncoding = sEncoding;
    if (myEncoding == null) {
      myEncoding = "ISO-8859-1";
    }

    try {
      bytes = input.getBytes(encoding);
    } catch (UnsupportedEncodingException ex) {
      throw new RuntimeException(this.getClass().getName() + "[Constructor] Unable to convert"
          + "properly char to bytes");
    }
    this.stringp = true;
    this.in = new ByteArrayInputStream(bytes);
    this.encoding = myEncoding;

    this.out = new ByteArrayOutputStream();
  }

  /**
   * Create a decoder to decode a stream.
   * 
   * @param isIn
   *            The input stream (to be decoded).
   * @param isOut
   *            The output stream, to write decoded data to.
   */

  public Base64Decoder(final InputStream isIn, final OutputStream isOut) {
    this.in = isIn;
    this.out = isOut;
    this.stringp = false;
  }

  /**
   * Test the decoder. Run it with one argument: the string to be decoded, it
   * will print out the decoded value.
   * 
   * @param args
   *            String[]
   */

  public static void main(final String[] args) {
    if (args.length == 1) {
      try {
        Base64Decoder b = new Base64Decoder(args[0]);
        System.out.println("[" + b.processString() + "]");
      } catch (RuntimeException e) {
        System.out.println("Invalid Base64 format !");
        System.exit(1);
      }
    } else if ((args.length == 2) && (args[0].equals("-f"))) {
      try {
        FileInputStream in = new FileInputStream(args[1]);
        Base64Decoder b = new Base64Decoder(in, System.out);
        b.process();
      } catch (Exception ex) {
        System.out.println("error: " + ex.getMessage());
        System.exit(1);
      }
    } else {
      System.out.println("Base64Decoder [strong] [-f file]");
    }
    System.exit(0);
  }
}
