/**
 * 
 */
package de.mcs.utils.caches;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Properties;

/**
 * @author w.klaas
 */
public class FolderBlocker {

  private File messFile;

  private RandomAccessFile fosdirlock;

  private FileLock lock;

  public FolderBlocker(final File path, final boolean block) throws IOException {
    messFile = new File(path, "Don't_mess_with_this_files.txt");
    if (!messFile.exists()) {
      Properties messProps = new Properties();
      try {
        messProps.store(new FileOutputStream(messFile), "Don't mess with this files");
      } catch (Exception e) {
      }
    }
    if (block) {
      // now blocking the folder
      try {
        File dirLock = new File(path, ".dirlock");
        fosdirlock = new RandomAccessFile(dirLock, "rws");
        FileChannel f = fosdirlock.getChannel();
        lock = f.tryLock();
        if (lock != null) {
          dirLock.deleteOnExit();
          ByteBuffer bytes = ByteBuffer.allocate(8); // a long is 8 bytes
          bytes.putLong(System.currentTimeMillis() + 10000).flip();
          f.write(bytes); // Write the buffer contents to the channel
          f.force(false); // Force them out to the disk
        } else {
          throw new OverlappingFileLockException();
        }
      } catch (FileNotFoundException e) {
        // e.printStackTrace();
      }
    }
  }

  public void freeResources() {
    if (fosdirlock != null) {
      try {
        // Closing the RandomAccessFile also closes its FileChannel.
        if (lock != null && lock.isValid()) {
          lock.release();
        }
        fosdirlock.close();
        fosdirlock = null;
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
  }

  protected void finalize() throws Throwable {
    super.finalize();
    freeResources();
  }
}
