/*
 * EASY Enterprise Engine
 * Copyright (c) 2004 by EASY Software AG
 * --------------------------------------
 * Created on 30.01.2004 by W.Klaas
 */
package de.mcs.utils;

import java.io.UnsupportedEncodingException;

import de.mcs.utils.codecs.Base64;

/**
 * Dieses Klasse dient der Zeichenkonvertierung f�r XML.
 * 
 * @author W.Klaas
 */
public final class XMLConverter {
    /** supress instancing. */
    private XMLConverter() {
    }

    private static final String BOUNDARY_BASE64 = "{b64}";

    public static void main(String[] args) {
	System.out.println("1:" + convertDataToXML("test von Zeichen."));
	System.out.println("2:" + convertDataToXML("test & < > ' \" Zeichen."));
	System.out.println("3:" + convertDataToXML("&test von Zeichen.>"));
	System.out.println("4:" + convertDataToXML("&"));
    }

    /**
     * Konvertiert die speziellen XML Sonderzeichen in die Entities & = &amp;,
     * &lt; = &amp;lt;, &gt; = &amp;gt;, " = &amp;qout;, ' == &amp;apos;.
     * 
     * @param data
     *            zu konvertierenden Eingangsstring
     * @return konvertierter String
     */
    public static String convertDataToXML(final String data) {
	char[] chars = data.toCharArray();
	StringBuffer result = new StringBuffer();
	if (data != null) {
	    int length = data.length();
	    int fpos = 0;
	    for (int i = 0; i < length; i++) {
		char ch = chars[i];
		switch (ch) {
		case '&':
		    result.append(data.substring(fpos, i));
		    result.append("&amp;");
		    fpos = i + 1;
		    break;
		case '<':
		    result.append(data.substring(fpos, i));
		    result.append("&lt;");
		    fpos = i + 1;
		    break;
		case '>':
		    result.append(data.substring(fpos, i));
		    result.append("&gt;");
		    fpos = i + 1;
		    break;
		case '"':
		    result.append(data.substring(fpos, i));
		    result.append("&quot;");
		    fpos = i + 1;
		    break;
		case '\'':
		    result.append(data.substring(fpos, i));
		    result.append("&apos;");
		    fpos = i + 1;
		    break;
		default:
		    break;
		}
	    }
	    if (fpos < length) {
		result.append(data.substring(fpos, length));
	    }
	}
	return result.toString();
    }

    /**
     * Diese Routine erzeugt einen CDATA Abschnitt.
     * 
     * @param data
     *            Eingangsstring der in einen CDATA Teil konvertiert werden soll
     * @return konvertierter Ausgangsstring
     */
    public static String convertDataToCDATA(final String data) {
	String mydata = "<![CDATA[" + data + "]]>";
	return mydata;
    }

    /**
     * THis function determine if the string data has illegal XML characters
     * like #00.
     * 
     * @param data
     *            String to determine
     * @return boolean true, if there are illegal charaters, false if everything
     *         is ok for XML
     */
    public static boolean mustEncode(final String data) {
	if (data != null) {
	    return hasIllegalXMLChar(data) | (data.indexOf("]]>") >= 0);
	} else {
	    return false;
	}
    }

    /**
     * THis function determine if the string data has illegal XML characters
     * like #00.
     * 
     * @param data
     *            String to determine
     * @return boolean true, if there are illegal charaters, false if everything
     *         is ok for XML
     */
    public static boolean hasIllegalXMLChar(final String data) {
	if (data != null) {
	    char[] chars = data.toCharArray();
	    boolean result = false;
	    for (int n = 0; n < chars.length && !result; n++) {
		result = result | XMLChar.isInvalid(chars[n]);
	    }
	    return result;
	} else {
	    return false;
	}
    }

    /**
     * automatically encode string data into an xml conform string. If non valid
     * xml charaters are present, the string will be base64 coded.
     * 
     * @param data
     * @return encoded string
     */
    public static String encodeStringData(final String data) {
	String value = data;
	if (XMLConverter.mustEncode(value)) {
	    try {
		value = BOUNDARY_BASE64
			+ Base64.encodeBytes(value.getBytes("UTF-8"));
	    } catch (UnsupportedEncodingException e) {
		throw new Error(e);
	    }
	}
	return value;
    }

    /**
     * automatically decode string data from an xml conform string. If string is
     * base64 coded it will be automatically converted back to string.
     * 
     * @param data
     * @return decoded string
     */
    public static String decodeStringData(final String data) {
	String value = data;
	if (value.startsWith(BOUNDARY_BASE64)) {
	    try {
		value = new String(Base64.decode(value
			.substring(BOUNDARY_BASE64.length())), "UTF-8");
	    } catch (UnsupportedEncodingException e) {
		throw new Error(e);
	    }
	}
	return value;
    }
}
