/*
 * MCS Media Computer Software Copyright (c) 2006 by MCS
 * -------------------------------------- Created on 11.04.2006 by w.klaas
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package de.mcs.utils;

/**
 * This is the working thread class needed for the threadedpool.
 * 
 * @author w.klaas
 * 
 */
public class WorkingThread extends Thread {

    /** my runnabe interface. */
    private Runnable run = null;

    /** just nothing to do. */
    private boolean free = true;

    /**
     * setting a new runnable.
     * 
     * @param runit
     *            the runnable.
     */
    public final void setRunnable(final Runnable runit) {
        this.run = runit;
    }

    /**
     * @see java.lang.Thread#run()
     */
    @Override
    public final void run() {
        setBusy();
        if (null != run) {
            run.run();
        }
        setFree();
    }

    /**
     * @return Returns the free.
     */
    public final boolean isFree() {
        return free;
    }

    /**
     * setting the free state.
     */
    public final void setFree() {
        this.free = true;
    }

    /**
     * setting this thread to busy.
     */
    public final void setBusy() {
        this.free = false;
    }

}
