/**
 * MCS Media Computer Software
 * Copyright 2014 by Wilfried Klaas
 * Project: MCSUtils
 * File: URLUtilities.java
 * EMail: W.Klaas@gmx.de
 * Created: 16.02.2014 wklaa_000
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 */
package de.mcs.utils;

import java.io.IOException;
import java.net.URISyntaxException;

/**
 * @author wklaa_000
 * 
 */
public class URLUtilities {

  public static void openUrl(String url) throws IOException, URISyntaxException {
    if (java.awt.Desktop.isDesktopSupported()) {
      java.awt.Desktop desktop = java.awt.Desktop.getDesktop();

      if (desktop.isSupported(java.awt.Desktop.Action.BROWSE)) {
        java.net.URI uri = new java.net.URI(url);
        desktop.browse(uri);
      }
    }
  }

}
