package de.mcs.utils;

import java.sql.Date;

/**
 * Helper class for onverting time stamps
 * 
 * @author w.klaas
 */
public class TimeHelper {

  /**
   * Converting seconds into millis
   * 
   * @param value
   *          seconds
   * @return millis
   */
  public static long sec2millis(long value) {
    return value * 1000;
  }

  /**
   * Converting mintues into millis
   * 
   * @param value
   *          minutes
   * @return millis
   */
  public static long min2millis(long value) {
    return value * 1000 * 60;
  }

  /**
   * Converting hours into millis
   * 
   * @param value
   *          hours
   * @return millis
   */
  public static long hour2millis(long value) {
    return value * 1000 * 60 * 60;
  }

  /**
   * Converting millis into seconds (the rest will be ignored, no rounding)
   * 
   * @param value
   *          millis
   * @return seconds
   */
  public static long millis2sec(long value) {
    return value / 1000;
  }

  /**
   * Converting millis into minutes (the rest will be ignored, no rounding)
   * 
   * @param value
   *          millis
   * @return minutes
   */
  public static long millis2min(long value) {
    return value / (1000 * 60);
  }

  /**
   * Converting millis into hours (the rest will be ignored, no rounding)
   * 
   * @param value
   *          millis
   * @return hours
   */
  public static long millis2hour(long value) {
    return value / (1000 * 60 * 60);
  }

  /**
   * Converting minutes into seconds
   * 
   * @param value
   *          minutes
   * @return seconds
   */
  public static long min2sec(long value) {
    return value * 60;
  }

  /**
   * Converting hours into seconds
   * 
   * @param value
   *          hours
   * @return seconds
   */
  public static long hour2sec(long value) {
    return value * 60 * 60;
  }

  /**
   * Converting hours into minutes
   * 
   * @param value
   *          hours
   * @return minutes
   */
  public static long hour2min(long value) {
    return value * 60;
  }

  /**
   * Converting seconds into minutes (the rest will be ignored, no rounding)
   * 
   * @param value
   *          seconds
   * @return minutes
   */
  public static long sec2min(long value) {
    return value / 60;
  }

  /**
   * Converting seconds into hours (the rest will be ignored, no rounding)
   * 
   * @param value
   *          seconds
   * @return hours
   */
  public static long sec2hour(long value) {
    return value / (60 * 60);
  }

  /**
   * Converting minutes into hours (the rest will be ignored, no rounding)
   * 
   * @param value
   *          minutes
   * @return hours
   */
  public static long min2hour(long value) {
    return value / 60;
  }

  /**
   * Converting date into millis
   * 
   * @param value
   *          date
   * @return millis
   */
  public static long date2millis(Date value) {
    return value.getTime();
  }

  /**
   * Converting millis into date
   * 
   * @param value
   *          millis
   * @return date
   */
  public static Date date2millis(long value) {
    return new Date(value);
  }
}
