/*
 * MCS Media Computer Software Copyright (c) 2005 by MCS
 * -------------------------------------- Created on 16.01.2004 by w.klaas
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package de.mcs.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

/**
 * A threaded stream reader needed for starting external processes.
 * 
 * @author w.klaas
 */
public class StreamReaderThread extends Thread {
    /** where to put the results to. */
    private OutputStream mOut;

    /** where to get the result from. */
    private InputStreamReader mIn;

    /**
     * constructor with in and out Streams.
     * 
     * @param in
     *            inputstream
     * @param out
     *            Printstream for output
     */
    public StreamReaderThread(final InputStream in, final OutputStream out) {
        mOut = out;
        mIn = new InputStreamReader(in);
    }

    /**
     * Threaded run. Now all data will be copied from in to out.
     */
    public final void run() {
        int ch;
        try {
            while (-1 != (ch = mIn.read())) {
                mOut.write((char) ch);
            }
        } catch (Exception e) {
            try {
                mOut.write(("\nRead error:" + e.getMessage()).getBytes());
            } catch (IOException e1) {
            }
        }
    }
}
