/*
 * MCS Media Computer Software Copyright (c) 2005 by MCS
 * -------------------------------------- Created on 16.01.2004 by w.klaas
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package de.mcs.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Starting a process like java.
 * 
 * @author w.klaas
 * 
 */
public final class StartProcess {

  /** prevent insancing. */
  private StartProcess() {

  }

  /**
   * Starting java with a command list and optionally wait for program ending.
   * 
   * @param command
   *          list of all needed parameters
   * @param wait
   *          wait for program ending
   * @param workingDir
   *          where is the working dir for this vm.
   * @return the exit code of the process
   */
  public static int startJava(final List<String> command, final boolean wait, final String workingDir) {
    Runtime rt = Runtime.getRuntime();
    File workingDirFile = new File(workingDir);
    int result = 0;
    // prepare buffers for process output and error streams
    // StringBuffer err = new StringBuffer();
    // StringBuffer out = new StringBuffer();

    try {
      Process p = rt.exec((String[]) command.toArray(new String[command.size()]), null, workingDirFile);
      // Process p = rt.exec((String[]) command.toArray(new String[0]),
      // null, workingDir);
      // create thread for reading inputStream (process' stdout)
      StreamReaderThread outThread = new StreamReaderThread(p.getInputStream(), System.out);
      // create thread for reading errorStream (process' stderr)
      StreamReaderThread errThread = new StreamReaderThread(p.getErrorStream(), System.err);
      // start both threads
      outThread.start();
      errThread.start();
      // wait for process to end
      if (wait) {
        result = p.waitFor();
        // finish reading whatever's left in the buffers
        outThread.join();
        errThread.join();

        if (result != 0) {
          System.err.println("Process " + command.get(0) + " returned non-zero value:" + result);
        } else {
          System.out.println("Process " + command.get(0) + " executed successfully");
        }
      }
    } catch (IOException e) {
      e.printStackTrace();
      // } catch (InterruptedException e) {
      // e.printStackTrace();
    } catch (InterruptedException e) {
      e.printStackTrace();
    }
    return result;
  }

  /**
   * chaging file permissions.
   * 
   * @param file
   *          which file to change.
   * @return result
   */
  public static int changeFilePermissions(final File file) {
    int result = 0;
    if (OSInformations.isMACOSX()) {
      List<String> command = new ArrayList<String>();
      command.add("chmod");
      command.add("755");
      command.add(file.getAbsolutePath());
      result = startJava(command, true, file.getParent());
      // do nothing for other systems at the moment
    }
    return result;
  }
}
