/*
 * MCS Media Computer Software Copyright (c) 2007 by MCS
 * -------------------------------------- Created on 21.11.2007 by w.klaas
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * 
 */
package de.mcs.utils;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;

/**
 * @author w.klaas
 * 
 */
public class PortTest extends Thread {

  private String server;

  private int port;

  private boolean result;

  public PortTest(String server, int port) {
    this.server = server;
    this.port = port;
  }

  public void setServer(String param) {
    this.server = param;
  }

  public String getServer() {
    return server;
  }

  public void setPort(int param) {
    this.port = param;
  }

  public int getPort() {
    return port;
  }

  public boolean checkPortWithoutPing() {
    long timeStart = System.currentTimeMillis();
    boolean success = false;
    try {
      Socket s = new Socket(server, port);
      s.close();
      success = true;
    } catch (IOException e) {
      success = false;
    }
    long timeEnd = System.currentTimeMillis();
    // System.out.println("Portcheck w/o ping: " + (timeEnd - timeStart));
    return success;
  }

  public boolean checkPortWithPing() {
    long timeStart = System.currentTimeMillis();
    boolean success = false;
    if (pingServer()) {
      success = checkPortWithoutPing();
    } else
      success = false;
    long timeEnd = System.currentTimeMillis();
    System.out.println("Portcheck w ping: " + (timeEnd - timeStart));
    return success;
  }

  private boolean isLinux() {
    return !System.getProperty("os.name").toLowerCase().contains("windows");
  }

  public boolean pingServer() {
    long timeStart = System.currentTimeMillis();
    boolean success = false;

    ProcessBuilder pb = null;
    pb = new ProcessBuilder();
    String[] cmd = null;

    if (isLinux())
      cmd = new String[] { "ping", "-c", "1", server };
    else
      // windows
      cmd = new String[] { "ping", "-w", "250", "-n", "1", server };

    pb.command(cmd);
    Process p;

    try {
      p = pb.start();
    } catch (IOException e) {
      return success;
    }
    if (p != null) {
      try {
        p.waitFor();
        success = p.exitValue() == 0;
      } catch (InterruptedException e) {
        success = false;
      }
    }
    long timeEnd = System.currentTimeMillis();
    System.out.println("Ping: " + (timeEnd - timeStart));
    return success;
  }

  public static void main(String[] args) {
    PortTest portcheck = null;
    ArrayList<String> results = new ArrayList<String>();

    for (int x = 0; x < 65000; x++) {
      ArrayList<PortTest> list = new ArrayList<PortTest>();
      for (int i = 0; i < 100; i++) {
        PortTest porttest = new PortTest("127.0.0.1", i + (x * 100));
        porttest.start();
        list.add(porttest);
      }
      for (PortTest test : list) {
        while (test.isAlive()) {
        }
        if (test.getResult()) {
          results.add("Port " + test.getPort() + " is open.");
        } else {
          // results.add("Port " + test.getPort() + " is closed.");
        }
      }
      for (String string : results) {
        System.out.println(string);
      }
      results.clear();
    }

    // portcheck = new PortTest("192.168.0.112", 445);
    // // server does not exist
    // System.out.println("SERVER DOES NOT EXIST");
    // System.out.println(">>>with Ping: " + portcheck.checkPortWithPing());
    // System.out.println(">>>w/o Ping: " +
    // portcheck.checkPortWithoutPing());
    //
    // portcheck.setServer("localhost");
    // // server does exist, port does exist
    // System.out.println("SERVER EXISTS, PORT OPEN");
    // System.out.println(">>>with Ping: " + portcheck.checkPortWithPing());
    // System.out.println(">>>w/o Ping: " +
    // portcheck.checkPortWithoutPing());
    //
    // portcheck.setPort(4711);
    // // server does exist, port does not
    // System.out.println("SERVER EXISTS, PORT CLOSED");
    // System.out.println(">>>with Ping: " + portcheck.checkPortWithPing());
    // System.out.println(">>>w/o Ping:  " + portcheck.checkPortWithoutPing());
  }

  public void run() {
    result = checkPortWithoutPing();
  }

  /**
   * @return the result
   */
  public boolean getResult() {
    return result;
  }

  public static int nextFreePort(int min, int max) {
    for (int x = min; x <= max; x++) {
      PortTest porttest = new PortTest("127.0.0.1", x);
      porttest.start();
      while (porttest.isAlive()) {
        try {
          sleep(500);
        } catch (InterruptedException e) {
          e.printStackTrace();
          return -1;
        }
      }
      if (!porttest.getResult()) {
        return x;
      }
    }

    return -1;
  }
}
