/*
 * MCS Media Computer Software Copyright (c) 2005 by MCS
 * -------------------------------------- Created on 16.01.2004 by w.klaas
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package de.mcs.utils;

/**
 * Hetting informations about the underrlying OS.
 * 
 * @author w.klaas
 * 
 */
public final class OSInformations {

    /** prevent instancing. */
    private OSInformations() {

    }

    /** the OS version. */
    private static String myOSVersion = System.getProperty("os.name");

    /** the framework runs on windows. */
    private static boolean bWin32 = false;
    static {
        bWin32 = (System.getProperty("os.name").toUpperCase()
                .startsWith("WINDOWS"));
    }

    /** the framework runs on MAC OS X. */
    private static boolean bMACOSX = false;
    static {
        bMACOSX = (System.getProperty("os.name").toUpperCase().substring(0, 3)
                .equals("MAC"));
    }

    /**
     * checking the underlying OS.
     * 
     * @param args
     *            not used.
     */
    public static void main(final String[] args) {
        System.out.print("Win32:");
        System.out.println(bWin32);
        System.out.print("MacOSX:");
        System.out.println(bMACOSX);
    }

    /**
     * @return is this vm running on MACOSX
     */
    public static boolean isMACOSX() {
        return bMACOSX;
    }

    /**
     * @return is this vm running on MACOSX
     */
    public static boolean isWin32() {
        return bWin32;
    }

    /**
     * @return getting the OS version string.
     */
    public static String getOSVersion() {
        return myOSVersion;
    }
}
