/*
 * MCS Media Computer Software Copyright (c) 2007 by MCS
 * -------------------------------------- Created on 23.01.2007 by w.klaas
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * 
 */
package de.mcs.utils;

/**
 * This class helps to convert numbers.
 * 
 * @author w.klaas
 * 
 */
public class NumberHelper {

    private static final String CONVERT_UNITS = "KMGkmg";

    private static final String CONVERT_TIMES = "YMDhms";

    public static int parseInt(final String valueStr) {
        String newValue = valueStr;
        int unit = 1;
        if (CONVERT_UNITS.indexOf(valueStr.charAt(valueStr.length() - 1)) >= 0) {
            switch (valueStr.charAt(valueStr.length() - 1)) {
            case 'K':
                unit = 1024;
                break;
            case 'M':
                unit = 1024 * 1024;
                break;
            case 'G':
                unit = 1024 * 1024 * 1024;
                break;
            case 'k':
                unit = 1000;
                break;
            case 'm':
                unit = 1000 * 1000;
                break;
            case 'g':
                unit = 1000 * 1000 * 1000;
                break;
            default:
                break;
            }
            newValue = newValue.substring(0, newValue.length() - 1);
        }
        return Integer.parseInt(newValue) * unit;
    }

    public static long parseTime(final String valueStr) {
        String newValue = valueStr;
        int unit = 1;
        if (CONVERT_TIMES.indexOf(valueStr.charAt(valueStr.length() - 1)) >= 0) {
            switch (valueStr.charAt(valueStr.length() - 1)) {
            case 'D':
                unit = unit * 24;
            case 'h':
                unit = unit * 60;
            case 'm':
                unit = unit * 60;
            case 's':
                unit = unit * 1000;
                break;
            default:
                break;
            }
            newValue = newValue.substring(0, newValue.length() - 1);
        }
        return Long.parseLong(newValue) * unit;
    }

}
