/**
 * 
 */
package de.mcs.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

/**
 * @author w.klaas
 * 
 */
public class NamedList {

  private Map<String, String> list;

  public NamedList() {
    list = new HashMap<String, String>();
  }

  public void add(final String key, final String value) {
    list.put(key, value);
  }

  public String get(final String key) {
    return list.get(key);
  }

  public String remove(final String key) {
    return list.remove(key);
  }

  public String toString() {
    StringBuilder b = new StringBuilder();
    for (Entry<String, String> entry : list.entrySet()) {
      b.append(entry.getKey());
      b.append("=");
      try {
        if (entry.getValue() != null) {
          b.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
      } catch (UnsupportedEncodingException e) {
      }
      b.append(";");
    }
    return b.substring(0, b.length() - 1).toString();
  }

  public void parseString(final String line) {
    String[] keyValues = line.split(";");
    for (String entry : keyValues) {
      if ((entry != null) && !entry.equals("")) {
        String[] entryValues = entry.split("=");
        if (entryValues.length > 0) {
          String key = entryValues[0];
          String value = null;
          if (entryValues.length > 1) {
            try {
              value = URLDecoder.decode(entryValues[1], "UTF-8");
            } catch (UnsupportedEncodingException e) {
            }
          }
          add(key, value);
        }
      }
    }
  }

  public static void main(String[] args) {
    NamedList list = new NamedList();
    list.add("test1", "test1");
    list.add("test2", "test;:#'+*!\"§$%&/()=");
    System.out.println(list.toString());

    NamedList list2 = new NamedList();
    list2.parseString(list.toString());
    System.out.println(list2.toString());
  }
}
