/**
 * 
 */
package de.mcs.utils;

import java.io.File;

import javax.activation.MimetypesFileTypeMap;

/**
 * @author w.klaas
 * 
 */
public class MimetypeFactory {

  public static final String DEFAULT_MIMETYPE = "application/octet-stream";

  private static MimetypesFileTypeMap MimetypeMap = new MimetypesFileTypeMap();

  public static String getFileMimtype(final File file) {
    String mimetype = MimetypeMap.getContentType(file);
    if (mimetype.equals(DEFAULT_MIMETYPE)) {
      return getFileMimtype(file.getAbsolutePath().toLowerCase());
    }
    return mimetype;
  }

  public static String getFileMimtype(final String filename) {
    return MimetypeMap.getContentType(filename.toLowerCase());
  }
}
