/*
 * MCS Media Computer Software Copyright (c) 2006 by MCS
 * -------------------------------------- Created on 10.01.2006 by w.klaas
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package de.mcs.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Some helper methode to build and convert a MD5 hash. For building MD5 from
 * files see de.mcs.utils.Files#computeMD5FromFile(String)
 * 
 * @author w.klaas
 * 
 */
public final class MD5Utils {

    /**
     * to prevent instancing.
     */
    private MD5Utils() {
    }

    /**
     * Building the md5 bytes from byte array.
     * 
     * @param s
     *            data byte array
     * @return byte[] byte array with md5
     */
    public static byte[] md5Bytes(final byte[] s) {
	// Build MD5-hashcode
	MessageDigest md;
	try {
	    md = MessageDigest.getInstance("MD5");
	    md.update(s);
	    byte[] digest = md.digest();

	    return digest;
	} catch (NoSuchAlgorithmException e) {
	    e.printStackTrace();
	}
	return null;
    }

    /**
     * Building the md5 bytes from byte array.
     * 
     * @param s
     *            data byte array
     * @return byte[] byte array with md5
     */
    public static byte[] md5Bytes(final byte[][] s) {
	// Build MD5-hashcode
	MessageDigest md;
	try {
	    md = MessageDigest.getInstance("MD5");
	    for (byte[] bs : s) {
		md.update(bs);
	    }

	    byte[] digest = md.digest();

	    return digest;
	} catch (NoSuchAlgorithmException e) {
	    e.printStackTrace();
	}
	return null;
    }

    /**
     * convinient functions to convert a MD5 stirng to the byte array.
     * 
     * @param md5String
     *            the string to convert.
     * @return byte[]
     */
    public static byte[] md5StringTobytes(final String md5String) {
	return StringFormat.fromHexString(md5String);
    }

    /**
     * convinient functions to convert a MD5 digest (as byte[]) to a string.
     * 
     * @param digest
     *            the byte[] to convert.
     * @return String
     */
    public static String md5BytesToString(final byte[] digest) {
	return StringFormat.toHexString(digest);
    }
}
