/**
 * 
 */
package de.mcs.utils;

import java.io.StringWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;

/**
 * @author w.klaas
 * 
 */
public class HTMLEncoder {

  private static final char c[] = { '<', '>', '&', '\"' };
  private static final String expansion[] = { "&lt;", "&gt;", "&amp;", "&quot;" };

  public static String HTMLEncode(String s) {
    if (s == null) {
      return null;
    }
    StringBuffer st = new StringBuffer();
    for (int i = 0; i < s.length(); i++) {
      boolean copy = true;
      char ch = s.charAt(i);
      for (int j = 0; j < c.length; j++) {
        if (c[j] == ch) {
          st.append(expansion[j]);
          copy = false;
          break;
        }
      }
      if (copy)
        st.append(ch);
    }
    return st.toString();
  }

  /**
   * This method is overriden to map any character entities, such as &lt; to
   * &amp;lt;. <code>super.output</code> will be invoked to write the content.
   * 
   * @since 1.3
   */
  public static String encode(String string) {
    if (string == null) {
      return null;
    }
    char[] chars = string.toCharArray();
    StringWriter output = new StringWriter();
    int last = 0;
    int length = chars.length;
    for (int counter = 0; counter < length; counter++) {
      // This will change, we need better support character level
      // entities.
      switch (chars[counter]) {
      // Character level entities.
      case '<':
        if (counter > last) {
          output.write(chars, last, counter - last);
        }
        last = counter + 1;
        output.write("&lt;");
        break;
      case '>':
        if (counter > last) {
          output.write(chars, last, counter - last);
        }
        last = counter + 1;
        output.write("&gt;");
        break;
      case '&':
        if (counter > last) {
          output.write(chars, last, counter - last);
        }
        last = counter + 1;
        output.write("&amp;");
        break;
      case '"':
        if (counter > last) {
          output.write(chars, last, counter - last);
        }
        last = counter + 1;
        output.write("&quot;");
        break;
      // Special characters
      case '\n':
        if (counter > last) {
          output.write(chars, last, counter - last);
        }
        last = counter + 1;
        output.write("<br/>");
        break;
      case '\t':
      case '\r':
        break;
      default:
        if (chars[counter] < ' ' || chars[counter] > 127) {
          if (counter > last) {
            output.write(chars, last, counter - last);
          }
          last = counter + 1;
          // If the character is outside of ascii, write the
          // numeric value.
          output.write("&#");
          output.write(String.valueOf((int) chars[counter]));
          output.write(";");
        }
        break;
      }
    }
    if (last < length) {
      output.write(chars, last, length - last);
    }
    return output.toString();
  }

  public static String URLEncode(String string) {
    if (string == null) {
      return null;
    }
    return URLEncoder.encode(string);
  }

  public static String URLDencode(String string) {
    if (string == null) {
      return null;
    }
    return URLDecoder.decode(string);
  }

  public static String stringToHTMLString(String string) {
    StringBuffer sb = new StringBuffer(string.length());
    // true if last char was blank
    boolean lastWasBlankChar = false;
    int len = string.length();
    char c;

    for (int i = 0; i < len; i++) {
      c = string.charAt(i);
      if (c == ' ') {
        // blank gets extra work,
        // this solves the problem you get if you replace all
        // blanks with &nbsp;, if you do that you loss
        // word breaking
        if (lastWasBlankChar) {
          lastWasBlankChar = false;
          sb.append("&nbsp;");
        } else {
          lastWasBlankChar = true;
          sb.append(' ');
        }
      } else {
        lastWasBlankChar = false;
        //
        // HTML Special Chars
        if (c == '"')
          sb.append("&quot;");
        else if (c == '&')
          sb.append("&amp;");
        else if (c == '<')
          sb.append("&lt;");
        else if (c == '>')
          sb.append("&gt;");
        else if (c == '\r')
          ;
        else if (c == '\n')
          // Handle Newline
          sb.append("<br/>");
        else {
          int ci = 0xffff & c;
          if (ci < 160)
            // nothing special only 7 Bit
            sb.append(c);
          else {
            // Not 7 Bit use the unicode system
            sb.append("&#");
            sb.append(new Integer(ci).toString());
            sb.append(';');
          }
        }
      }
    }
    return sb.toString();
  }

  public static void main(String[] args) {
    System.out.println(stringToHTMLString(" abcdefghijklmnopqrstuvwxyzüäöÜÄÖß<>;&%$§\r\n \n"));
  }
}
