/*
 * MCS Media Computer Software Copyright (c) 2005 by MCS
 * -------------------------------------- Created on 16.01.2004 by w.klaas
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package de.mcs.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;

/**
 * Environment class simulates the System.getenv() method which is deprecated on
 * java 1.4.2.
 * 
 * @author v-josp
 */
public final class GetEnviroment {
    /** prevent instancing. */
    private GetEnviroment() {
    }

    /** result of all enviornment variables. */
    private static BufferedReader commandResult;

    /** map with all commands. */
    private static HashMap<String, String> commandList;
    static {
        String cmd = null;
        String os = null;

        // getting the OS name
        os = System.getProperty("os.name").toLowerCase();

        // according to OS set the command to execute
        if (os.startsWith("windows")) {
            cmd = "cmd /c SET";
        } else {
            cmd = "env";
        }

        try {
            // execute the command and get the result in the form of InputStream
            Process p = Runtime.getRuntime().exec(cmd);

            // parse the InputStream data
            InputStreamReader isr = new InputStreamReader(p.getInputStream());
            commandResult = new BufferedReader(isr);
        } catch (Exception e) {
            System.out.println("OSEnvironment.class error: " + cmd + ":" + e);
        }
        commandList = new HashMap<String, String>();

        String line = null;
        try {
            while ((line = commandResult.readLine()) != null) {
                String key = line.substring(0, line.indexOf('='));
                String value = line.substring(line.indexOf('=') + 1);
                commandList.put(key, value);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * This method is used to get the path of the given enviornment variable.
     * This method tries to simulates the System.getenv() which is deprecated on
     * java 1.4.2
     * 
     * @param envName
     *            name of the environment variable
     * @param defaultValue
     *            default value
     * @return String
     */
    public static String getenv(final String envName, final String defaultValue) {
        String value = defaultValue;
        if (commandList.containsKey(envName)) {
            value = (String) commandList.get(envName);
        }
        return value;
    }
}
