/*
 * MCS Media Computer Software Copyright (c) 2005 by MCS
 * -------------------------------------- Created on 16.01.2004 by w.klaas
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package de.mcs.utils;

/**
 * this function is missing in java.
 * 
 * @author W.Klaas
 */
public final class ExtendedBoolean {
    /**
     * Damit man diese Klasse nicht instanzieren kann.
     */
    private ExtendedBoolean() {
        // nothing to do here
    }

    /**
     * String in Boolean verwandeln.
     * 
     * @param name
     *            String
     * @return boolean
     */
    public static boolean toBoolean(final String name) {
        return ((name != null) && (name.equalsIgnoreCase("true") || name
                .equalsIgnoreCase("1")));
    }

    /**
     * String in Boolean verwandeln.
     * 
     * @param name
     *            String
     * @param defaultValue
     *            the default value.
     * @return boolean
     */
    public static boolean toBoolean(final String name,
            final boolean defaultValue) {
        boolean value = defaultValue;
        if ((name != null)) {
            if (!name.equals("")) {
                value = name.equalsIgnoreCase("true")
                        || name.equalsIgnoreCase("1");
            }
        }
        return value;
    }
}
