/*
 * MCS Media Computer Software Copyright (c) 2006 by MCS
 * -------------------------------------- Created on 13.01.2006 by w.klaas
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package de.mcs.utils;

/**
 * This exception will be thrown in cases where tsome error occured in the
 * conversions class.
 * 
 * @author w.klaas
 * 
 */
public class ConversionException extends Exception {

    /**
     * 
     */
    private static final long serialVersionUID = -7326424522974928879L;

    /**
     * constructor.
     * 
     */
    public ConversionException() {
        super();
    }

    /**
     * Constructor with message text.
     * 
     * @param message
     *            the message
     */
    public ConversionException(final String message) {
        super(message);
    }

    /**
     * Constructor with message text and another exception.
     * 
     * @param message
     *            the message
     * @param cause
     *            Throwable
     */
    public ConversionException(final String message, final Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor with another exception.
     * 
     * @param cause
     *            Throwable
     */
    public ConversionException(final Throwable cause) {
        super(cause);
    }

}
