package de.mcs.utils;

/*
 * Copyright (c) 2004 by MCS Software --------------------------------------
 * Created on 04.01.2005 by w.klaas
 */
/**
 * Build 16 bit checksum of some values.
 * 
 * @author w.klaas
 */
public final class Checksum16 {

    /** private constructor to prevent instancing. */
    private Checksum16() {
    };

    /**
     * parses the string and build the 16 bit checksum.
     * 
     * @param str
     *            string to build checksum from
     * @return int 16 bit checksum
     */
    public static int parseString(final String str) {
        return parseArray(str.getBytes());
    }

    /**
     * parses the byte array and build the 16 bit checksum.
     * 
     * @param array
     *            array to build checksum from
     * @return int 16 bit checksum
     */
    public static int parseArray(final byte[] array) {
        int lo = 0;
        int hi = 0;
        for (int n = 0; n < array.length; n++) {
            if ((n % 2) == 0) {
                lo = lo ^ array[n];
            } else {
                hi = hi ^ array[n];
            }
        }
        return lo + (hi << 8);
    }
}
