/*
 * MCS Media Computer Software Copyright (c) 2006 by MCS
 * -------------------------------------- Created on 12.01.2006 by w.klaas
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package de.mcs.utils;

import java.util.ArrayList;
import java.util.Arrays;

/**
 * Implements some utils for array hanling.
 * 
 * @author w.klaas
 * 
 */
public final class ArrayUtils {

    /** prevent instancing. */
    private ArrayUtils() {
    }

    /**
     * checking if 2 arrays are equal up to len length.
     * 
     * @param id
     *            first array
     * @param id2
     *            second array
     * @param len
     *            len to check.
     * @return <code>true</code> if the array are equal, otherwise
     *         <code>false</code>
     */
    public static boolean equals(final byte[] id, final byte[] id2,
            final int len) {
        if ((id != null) && (id2 != null)) {
            if ((id.length >= len) && (id2.length >= len)) {
                byte[] newid = new byte[len];
                System.arraycopy(id, 0, newid, 0, len);
                byte[] newid2 = new byte[len];
                System.arraycopy(id2, 0, newid2, 0, len);
                return Arrays.equals(newid, newid2);
            }
        }
        return false;
    }

    /**
     * converting a Strign into an array. Format is the internal format of the
     * toString methode of a array.
     * 
     * @param value
     *            the string to convert.
     * @return String[]
     */
    public static String[] stringToArray(final String value) {
        String line = value.trim();
        int pos = 0;
        int colonCount = 0;
        int start = 0;
        int stop = line.length();
        boolean inField = false;
        ArrayList<String> list = new ArrayList<String>();
        while (pos < line.length()) {
            char chr = line.charAt(pos);
            switch (chr) {
            case '[':
                if (!inField) {
                    colonCount++;
                    if (colonCount == 1) {
                        start = pos + 1;
                    }
                }
                break;
            case ']':
                if (!inField) {
                    colonCount--;
                    if (colonCount == 0) {
                        stop = pos;
                        list.add(line.substring(start, stop));
                        start = pos + 1;
                    }
                }
                break;
            case ',':
                if (!inField) {
                    if (colonCount == 1) {
                        stop = pos;
                        list.add(line.substring(start, stop));
                        start = pos + 1;
                    }
                }
                break;
            case '"':
                inField = !inField;
                break;
            default:
                break;
            }
            pos++;
        }
        return list.toArray(new String[0]);
    }
}
