/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.search.util;

import net.sourceforge.jbizmo.commons.search.dto.SearchDTO;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldDTO;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldDataTypeEnum;
import net.sourceforge.jbizmo.commons.search.dto.SearchInput;
import net.sourceforge.jbizmo.commons.search.dto.SearchInputField;
import net.sourceforge.jbizmo.commons.search.dto.SearchOperatorDTO;
import net.sourceforge.jbizmo.commons.search.util.SearchOperatorHelper;

public class SearchObjectConverter {
    private final SearchDTO searchObj = new SearchDTO();
    private final SearchInput searchInput;

    public SearchObjectConverter(SearchInput searchInput) {
        this.searchInput = searchInput;
        this.searchObj.setMaxResult(searchInput.getMaxResult());
        this.searchObj.setStartIndex(searchInput.getStartIndex());
        this.searchObj.setExactFilterMatch(searchInput.isExactFilterMatch());
        this.searchObj.setCaseSensitive(searchInput.isCaseSensitive());
        this.searchObj.setCount(false);
        this.searchObj.setDateFormat(searchInput.getDateFormat());
        this.searchObj.setDateTimeFormat(searchInput.getDateTimeFormat());
        this.searchObj.setNumberFormat(searchInput.getNumberFormat());
        this.searchObj.setDecimalSeparator(searchInput.getDecimalSeparator());
        this.searchObj.setGroupingSeparator(searchInput.getGroupingSeparator());
    }

    public void addSearchField(String selectClause, String fieldName, SearchFieldDataTypeEnum dataType, boolean dateTimeFormat) {
        SearchFieldDTO field = new SearchFieldDTO(this.searchObj.getSearchFields().size(), selectClause, fieldName, dataType, 0);
        field.setDateTimeFormat(dateTimeFormat);
        this.searchObj.getSearchFields().add(field);
    }

    public void addSearchField(String selectClause, String fieldName, SearchFieldDataTypeEnum dataType) {
        this.addSearchField(selectClause, fieldName, dataType, true);
    }

    public SearchDTO convert() {
        block0: for (SearchInputField inputField : this.searchInput.getSearchFields()) {
            for (SearchFieldDTO searchField : this.searchObj.getSearchFields()) {
                if (!inputField.getName().equals(searchField.getColLabel())) continue;
                searchField.setFilterCriteria(inputField.getFilterCriteria());
                searchField.setSortIndex(inputField.getSortIndex());
                searchField.setSortOrder(inputField.getSortOrder());
                searchField.setDateTimeFormat(inputField.isDateTimeFormat());
                if (inputField.getOperator() == null) continue block0;
                for (SearchOperatorDTO operator : SearchOperatorHelper.getOperatorsForField(searchField)) {
                    if (!operator.getValue().equals(inputField.getOperator().getValue())) continue;
                    searchField.setOperator(operator);
                    continue block0;
                }
                continue block0;
            }
        }
        return this.searchObj;
    }
}

