/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.search.dto;

import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldDTO;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldDataTypeEnum;

public class SearchDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int id;
    private int maxResult;
    private boolean caseSensitive;
    private String numberFormat;
    private String dateFormat;
    private boolean count;
    private int startIndex;
    private List<SearchFieldDTO> searchFields = new ArrayList<SearchFieldDTO>();
    private String fromClause;
    private boolean fetchHidden = true;
    private String groupBy;
    private String dateTimeFormat;
    private boolean exactFilterMatch;
    private char decimalSeparator;
    private char groupingSeparator;

    public SearchDTO() {
        this.setDecimalSeparator(DecimalFormatSymbols.getInstance().getDecimalSeparator());
        this.setGroupingSeparator(DecimalFormatSymbols.getInstance().getGroupingSeparator());
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public String getFromClause() {
        return this.fromClause;
    }

    public void setFromClause(String fromClause) {
        this.fromClause = fromClause;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public int getMaxResult() {
        return this.maxResult;
    }

    public void setMaxResult(int maxResult) {
        this.maxResult = maxResult;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
    }

    public List<SearchFieldDTO> getSearchFields() {
        return this.searchFields;
    }

    public void setSearchFields(List<SearchFieldDTO> searchFields) {
        this.searchFields = searchFields;
    }

    public boolean isCount() {
        return this.count;
    }

    public void setCount(boolean count) {
        this.count = count;
    }

    public boolean isFetchHidden() {
        return this.fetchHidden;
    }

    public void setFetchHidden(boolean fetchHidden) {
        this.fetchHidden = fetchHidden;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public boolean isExactFilterMatch() {
        return this.exactFilterMatch;
    }

    public void setExactFilterMatch(boolean exactFilterMatch) {
        this.exactFilterMatch = exactFilterMatch;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public void setGroupingSeparator(char groupingSeparator) {
        this.groupingSeparator = groupingSeparator;
    }

    public SearchFieldDTO addSearchField(String colName, SearchFieldDataTypeEnum dataType) {
        int colOrder = this.searchFields.stream().map(SearchFieldDTO::getColOrder).max(Integer::compare).orElse(-1) + 1;
        SearchFieldDTO searchField = new SearchFieldDTO(colOrder, colName, null, dataType, 0);
        this.getSearchFields().add(searchField);
        return searchField;
    }
}

