/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.property;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import net.sourceforge.jbizmo.commons.property.IllegalPropertyValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROP_EXCHANGE_FOLDER = "jbizmo.application.file-exchange-folder";
    public static final String PROP_LOGGING_LEVEL = "jbizmo.application.logging-level";
    public static final String PROP_TRANSPORT_AUTHENTICATION = "jbizmo.application.transport.authentication.enabled";
    public static final String PROP_TRANSPORT_SECRET = "jbizmo.application.transport.secret";
    public static final String PROP_REPOSITORY_FOLDER = "jbizmo.application.document-repository-folder";
    private static final String FILE_NAME = "application.properties";
    private static final String DEFAULT_PATH = "config/application.properties";
    private static final String DATE_FORMAT = "dd.MM.yyyy HH:mm:ss";
    private static final String DECIMAL_FORMAT = "0.00";
    private boolean propertiesLoaded;
    private Properties properties;
    private String pathToFile = "config/application.properties";

    public PropertyService() {
    }

    public PropertyService(String pathToFile) {
        this.pathToFile = pathToFile;
    }

    private String getProperty(String name) {
        if (!this.propertiesLoaded) {
            this.loadProperties();
        }
        if (!this.properties.containsKey(name)) {
            throw new IllegalPropertyValueException("Property '" + name + "' does not exist!");
        }
        String value = this.properties.getProperty(name);
        if (name.equals(PROP_TRANSPORT_SECRET)) {
            logger.debug("Property '{}' with value '******' found", (Object)name);
        } else {
            logger.debug("Property '{}' with value '{}' found", (Object)name, (Object)value);
        }
        return value;
    }

    public String getStringProperty(String name) {
        return this.getProperty(name);
    }

    public int getIntProperty(String name) {
        String propertyValue = this.getProperty(name);
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid integer value!");
        }
    }

    public long getLongProperty(String name) {
        String propertyValue = this.getProperty(name);
        try {
            return Long.parseLong(propertyValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid long value!");
        }
    }

    public double getDoubleProperty(String name) {
        String propertyValue = this.getProperty(name);
        DecimalFormat decimalFormat = new DecimalFormat(DECIMAL_FORMAT);
        try {
            Number n = decimalFormat.parse(propertyValue);
            return n.doubleValue();
        }
        catch (ParseException e) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid double value!");
        }
    }

    public float getFloatProperty(String name) {
        String propertyValue = this.getProperty(name);
        DecimalFormat decimalFormat = new DecimalFormat(DECIMAL_FORMAT);
        try {
            Number n = decimalFormat.parse(propertyValue);
            return n.floatValue();
        }
        catch (ParseException e) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid float value!");
        }
    }

    public char getCharProperty(String name) {
        String propertyValue = this.getProperty(name);
        if (propertyValue.isEmpty() || propertyValue.length() > 1) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid character value!");
        }
        return propertyValue.charAt(0);
    }

    public synchronized Date getDateProperty(String name) {
        String propertyValue = this.getProperty(name);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        try {
            return dateFormat.parse(propertyValue);
        }
        catch (ParseException e) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid java.util.Date value!");
        }
    }

    public boolean getBooleanProperty(String name) {
        String propertyValue = this.getProperty(name);
        return Boolean.parseBoolean(propertyValue);
    }

    private synchronized void loadProperties() {
        logger.debug("Loading properties from file '{}'", (Object)this.pathToFile);
        InputStream inputStream = PropertyService.class.getClassLoader().getResourceAsStream(this.pathToFile);
        if (inputStream == null && (inputStream = PropertyService.class.getClassLoader().getResourceAsStream(FILE_NAME)) == null) {
            throw new IllegalStateException("The file 'application.properties' could not be found!");
        }
        try {
            this.properties = new Properties();
            this.properties.load(inputStream);
        }
        catch (Exception e) {
            logger.error("Error while loading properties!", (Throwable)e);
            throw new IllegalStateException("Error while loading properties! Message: " + e.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.warn("Could not close input stream!", (Throwable)e);
            }
        }
        this.propertiesLoaded = true;
    }
}

