/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.jms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class RequestMessage
implements Serializable {
    private static final long serialVersionUID = -7974013223415178981L;
    private final String operationID;
    private final List<Serializable> parameters = new ArrayList<Serializable>();
    private int parameterIndex;

    public RequestMessage(String operationID) {
        this.operationID = operationID;
    }

    public String getOperationID() {
        return this.operationID;
    }

    public RequestMessage withParameter(Serializable value) {
        this.parameters.add(value);
        return this;
    }

    public Serializable getNextParameter() {
        return this.parameters.get(this.parameterIndex++);
    }

    public <T> T getNextParameter(Class<T> type) {
        return (T)this.getNextParameter();
    }

    public int getNextIntParameter() {
        return (Integer)this.getNextParameter();
    }

    public Integer getNextIntegerParameter() {
        return this.getNextParameter(Integer.class);
    }

    public long getNextLongParameter() {
        return (Long)this.getNextParameter();
    }

    public Long getNextLongObjectParameter() {
        return this.getNextParameter(Long.class);
    }

    public boolean getNextBoolParameter() {
        return (Boolean)this.getNextParameter();
    }

    public Boolean getNextBooleanParameter() {
        return this.getNextParameter(Boolean.class);
    }

    public float getNextFloatParameter() {
        return ((Float)this.getNextParameter()).floatValue();
    }

    public Float getNextFloatObjectParameter() {
        return this.getNextParameter(Float.class);
    }

    public double getNextDoubleParameter() {
        return (Double)this.getNextParameter();
    }

    public Double getNextDoubleObjectParameter() {
        return this.getNextParameter(Double.class);
    }

    public String getNextStringParameter() {
        return this.getNextParameter(String.class);
    }

    public UUID getNextUUIDParameter() {
        return this.getNextParameter(UUID.class);
    }

    public char getNextCharParameter() {
        return ((Character)this.getNextParameter()).charValue();
    }
}

