/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.i18n;

import java.lang.invoke.MethodHandles;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18N {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String LABEL_SEPARATOR = ":";

    private I18N() {
    }

    public static String getTranslation(ResourceBundle resourceBoundle, String key, Object ... params) {
        String msg;
        try {
            msg = resourceBoundle.getString(key);
        }
        catch (Exception e) {
            logger.error("Could not find translation for key '{}'!", (Object)key, (Object)e);
            return "???-" + key + "-???";
        }
        if (params.length > 0) {
            MessageFormat format = new MessageFormat(msg);
            msg = format.format(params);
        }
        return msg;
    }

    public static String getTranslationForFieldLabel(ResourceBundle resourceBoundle, String key) {
        return I18N.getTranslation(resourceBoundle, key, new Object[0]) + LABEL_SEPARATOR;
    }
}

