/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.authentication;

import java.util.Base64;

public class BasicAuthentication {
    public static final String HTTP_HEADER_AUTHORIZATION = "Authorization";
    private static final String BASIC_AUTH_PREFIX = "Basic ";
    private static final String DELIMITER = ":";

    private BasicAuthentication() {
    }

    public static String createAuthentication(String userName, String password) {
        String userNameAndPassword = userName + DELIMITER + password;
        return BASIC_AUTH_PREFIX + Base64.getEncoder().encodeToString(userNameAndPassword.getBytes());
    }

    public static String getUserName(String authenticationString) {
        return BasicAuthentication.extractField(authenticationString, true);
    }

    public static String getPassword(String authenticationString) {
        return BasicAuthentication.extractField(authenticationString, false);
    }

    private static String extractField(String authenticationString, boolean extractUserName) {
        if (authenticationString == null || authenticationString.isEmpty()) {
            throw new IllegalArgumentException("The parameter 'authenticationString' must not be null or empty!");
        }
        String decodedString = new String(Base64.getDecoder().decode(authenticationString.substring(BASIC_AUTH_PREFIX.length())));
        if (!decodedString.contains(DELIMITER)) {
            throw new IllegalArgumentException("Authentication string '" + authenticationString + "' has an illegal format!");
        }
        if (extractUserName) {
            return decodedString.substring(0, decodedString.indexOf(DELIMITER));
        }
        return decodedString.substring(decodedString.indexOf(DELIMITER) + 1);
    }
}

