/*
 * This file is part of JBizMo, a set of tools, libraries and plug-ins
 * for modeling and creating Java-based enterprise applications.
 * For more information visit:
 *
 * http://sourceforge.net/projects/jbizmo/
 *
 * This software is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package net.sourceforge.jbizmo.commons.jms;

import java.io.Serializable;

/**
 * <p>
 * Container object that holds all data of JMS response message
 * </p>
 * <p>
 * Copyright 2023 (C) by Martin Ganserer
 * </p>
 * @author Martin Ganserer
 * @version 1.0.0
 */
public class ResponseMessage implements Serializable {
	private static final long serialVersionUID = 5366908479603284548L;

	private final String operationID;
	private String text;
	private ResponseStatus status = ResponseStatus.SUCCESS;
	private Serializable object;

	/**
	 * Constructor
	 * @param operationID the ID of the operation
	 */
	public ResponseMessage(String operationID) {
		this.operationID = operationID;
	}

	/**
	 * @return the ID of the operation
	 */
	public String getOperationID() {
		return operationID;
	}

	/**
	 * @return an optional text
	 */
	public String getText() {
		return text;
	}

	/**
	 * @param text
	 */
	public void setText(String text) {
		this.text = text;
	}

	/**
	 * @return the response status
	 */
	public ResponseStatus getStatus() {
		return status;
	}

	/**
	 * @param status
	 */
	public void setStatus(ResponseStatus status) {
		this.status = status;
	}

	/**
	 * @return an object that was created by a respective operation
	 */
	public Serializable getObject() {
		return object;
	}

	/**
	 * @param object
	 */
	public void setObject(Serializable object) {
		this.object = object;
	}

}
