/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.crypto;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CipherFactory {
    private static final String ENCRYPTION_ALGORITHM = "AES";
    private static final String ENCRYPTION_TRANSFORM = "AES/CTR/NoPadding";
    private static final byte[] INIT_PARAM = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private final Key key;

    public CipherFactory(String secret) {
        this.key = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), ENCRYPTION_ALGORITHM);
    }

    public Cipher getEncryptionCipher() throws Exception {
        IvParameterSpec iv = new IvParameterSpec(INIT_PARAM);
        Cipher encryptionCipher = Cipher.getInstance(ENCRYPTION_TRANSFORM);
        encryptionCipher.init(1, this.key, iv);
        return encryptionCipher;
    }

    public Cipher getDecryptionCipher() throws Exception {
        IvParameterSpec iv = new IvParameterSpec(INIT_PARAM);
        Cipher decryptionCipher = Cipher.getInstance(ENCRYPTION_TRANSFORM);
        decryptionCipher.init(2, this.key, iv);
        return decryptionCipher;
    }
}

