/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.stream;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import net.sourceforge.jbizmo.commons.crypto.CipherFactory;

public class StreamWorker {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private final int bufferSize;

    public StreamWorker() {
        this(1024);
    }

    public StreamWorker(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void writeToOutput(InputStream in, OutputStream out, boolean encryptOutput, boolean decryptInput) throws Exception {
        byte[] buf = new byte[this.bufferSize <= 0 ? 1024 : this.bufferSize];
        int numRead = 0;
        if (encryptOutput) {
            out = new CipherOutputStream(out, CipherFactory.getEncryptionCipher());
        }
        if (decryptInput) {
            in = new CipherInputStream(in, CipherFactory.getDecryptionCipher());
        }
        while ((numRead = in.read(buf)) >= 0) {
            out.write(buf, 0, numRead);
        }
    }

    public Object readObjectFromStream(InputStream in, boolean decrypt) throws Exception {
        if (decrypt) {
            try (ObjectInputStream ois = new ObjectInputStream(new CipherInputStream(in, CipherFactory.getDecryptionCipher()));){
                Object object = ois.readObject();
                return object;
            }
        }
        try (ObjectInputStream ois = new ObjectInputStream(in);){
            Object object = ois.readObject();
            return object;
        }
    }

    public void writeObjectToStream(Serializable object, OutputStream out, boolean encrypt) throws Exception {
        if (encrypt) {
            try (ObjectOutputStream oos = new ObjectOutputStream(new CipherOutputStream(out, CipherFactory.getEncryptionCipher()));){
                oos.writeObject(object);
            }
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(out);){
            oos.writeObject(object);
        }
    }
}

