/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.search.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldDTO;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldDataTypeEnum;
import net.sourceforge.jbizmo.commons.search.dto.SearchOperatorDTO;

public class SearchOperatorHelper {
    private static HashMap<String, SearchOperatorDTO> operators;

    private SearchOperatorHelper() {
    }

    private static void initOperators() {
        int operatorId = 1;
        operators = new HashMap();
        operators.put("=", new SearchOperatorDTO(operatorId++, "=", "equal", true, true, true, true, true));
        operators.put("like", new SearchOperatorDTO(operatorId++, "like", "like", true, false, false, true, false));
        operators.put("not like", new SearchOperatorDTO(operatorId++, "not like", "not like", true, false, false, true, false));
        operators.put("in", new SearchOperatorDTO(operatorId++, "in", "in", true, false, false, true, true));
        operators.put("not in", new SearchOperatorDTO(operatorId++, "not in", "not in", true, false, false, true, true));
        operators.put("between", new SearchOperatorDTO(operatorId++, "between", "between", true, true, false, false, true));
        operators.put(">", new SearchOperatorDTO(operatorId++, ">", "greater", true, true, false, false, true));
        operators.put("<", new SearchOperatorDTO(operatorId++, "<", "smaller", true, true, false, false, true));
        operators.put(">=", new SearchOperatorDTO(operatorId++, ">=", "greater or equal", true, true, false, false, true));
        operators.put("<=", new SearchOperatorDTO(operatorId++, "<=", "smaller or equal", true, true, false, false, true));
        operators.put("is null", new SearchOperatorDTO(operatorId++, "is null", "is null", false, true, false, true, true));
        operators.put("is not null", new SearchOperatorDTO(operatorId, "is not null", "is not null", false, true, false, true, true));
    }

    public static List<SearchOperatorDTO> getAllOperators() {
        if (operators == null) {
            SearchOperatorHelper.initOperators();
        }
        return operators.values().stream().collect(Collectors.toList());
    }

    public static SearchOperatorDTO getOperator(String name) {
        if (operators == null) {
            SearchOperatorHelper.initOperators();
        }
        return operators.get(name);
    }

    public static List<SearchOperatorDTO> getOperatorsForField(SearchFieldDTO field) {
        ArrayList<SearchOperatorDTO> opList = new ArrayList<SearchOperatorDTO>();
        if (field.getDataType() == SearchFieldDataTypeEnum.BOOLEAN) {
            for (SearchOperatorDTO op : SearchOperatorHelper.getAllOperators()) {
                if (!op.isBooleanSupport()) continue;
                opList.add(op);
            }
        } else if (field.hasTemporalDataType()) {
            for (SearchOperatorDTO op : SearchOperatorHelper.getAllOperators()) {
                if (!op.isDateSupport()) continue;
                opList.add(op);
            }
        } else if (field.getDataType() == SearchFieldDataTypeEnum.STRING || field.getDataType() == SearchFieldDataTypeEnum.CHAR) {
            for (SearchOperatorDTO op : SearchOperatorHelper.getAllOperators()) {
                if (!op.isTextSupport()) continue;
                opList.add(op);
            }
        } else if (field.getDataType() == SearchFieldDataTypeEnum.ENUM) {
            for (SearchOperatorDTO op : SearchOperatorHelper.getAllOperators()) {
                if (op.getValue().equals("in") || op.getValue().equals("not in") || !op.isTextSupport()) continue;
                opList.add(op);
            }
        } else if (field.getDataType() == SearchFieldDataTypeEnum.UUID_STRING) {
            for (SearchOperatorDTO op : SearchOperatorHelper.getAllOperators()) {
                if (!op.getValue().equals("=") && !op.getValue().equals("not like") && !op.getValue().equals("like") && !op.getValue().equals("is null") && !op.getValue().equals("is not null") && !op.getValue().equals("in") && !op.getValue().equals("not in")) continue;
                opList.add(op);
            }
        } else if (field.getDataType() == SearchFieldDataTypeEnum.UUID_BINARY) {
            for (SearchOperatorDTO op : SearchOperatorHelper.getAllOperators()) {
                if (!op.getValue().equals("=") && !op.getValue().equals("is null") && !op.getValue().equals("is not null") && !op.getValue().equals("in") && !op.getValue().equals("not in")) continue;
                opList.add(op);
            }
        } else {
            for (SearchOperatorDTO op : SearchOperatorHelper.getAllOperators()) {
                if (!op.isNumberSupport()) continue;
                opList.add(op);
            }
        }
        return opList;
    }
}

