/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.crypto;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashGenerator {
    private static final String MD5 = "MD5";
    private static final String SHA256 = "SHA-256";

    private HashGenerator() {
    }

    private static String convertToHex(byte[] data) {
        StringBuilder b = new StringBuilder();
        for (byte aByte : data) {
            int halfbyte = aByte >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    b.append((char)(48 + halfbyte));
                } else {
                    b.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = aByte & 0xF;
            } while (two_halfs++ < 1);
        }
        return b.toString();
    }

    public static String encryptMD5(String text) throws NoSuchAlgorithmException {
        return HashGenerator.encrypt(text, MD5, StandardCharsets.UTF_8);
    }

    public static String encryptSHA256(String text) throws NoSuchAlgorithmException {
        return HashGenerator.encrypt(text, SHA256, StandardCharsets.UTF_8);
    }

    public static String encrypt(String text, String digester, Charset charset) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(digester);
        md.update(text.getBytes(charset), 0, text.length());
        return HashGenerator.convertToHex(md.digest());
    }
}

