/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.validation.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sourceforge.jbizmo.commons.validation.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstrainedClass {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Map<Class<?>, ConstrainedClass> constrainedClasses = Collections.synchronizedMap(new WeakHashMap());
    private Map<String, Set<Annotation>> propertyConstraintMap;
    private Set<String> constrainedProperties;
    private final Class<?> thisClass;

    private ConstrainedClass(Class<?> c) {
        this.thisClass = c;
        this.buildConstraintMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConstrainedClass getConstrainedClass(Class<?> theClass) {
        ConstrainedClass cc = constrainedClasses.get(theClass);
        if (cc == null) {
            Class<?> clazz = theClass;
            synchronized (clazz) {
                cc = constrainedClasses.computeIfAbsent(theClass, ConstrainedClass::new);
            }
        }
        return cc;
    }

    public static boolean isConstraint(Annotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("null is not a legal value for annotation");
        }
        return annotation.annotationType().isAnnotationPresent(Constraint.class);
    }

    public Set<Annotation> getConstraints(String propertyName) throws IntrospectionException {
        if (propertyName == null) {
            throw new IllegalArgumentException("null is not a legal value for propertyName");
        }
        Set<Annotation> c = this.propertyConstraintMap.get(propertyName);
        if (c == null) {
            throw new IntrospectionException("propertyName");
        }
        return c;
    }

    public Set<String> getConstrainedProperties() {
        return this.constrainedProperties;
    }

    private void buildConstraintMap() {
        HashMap<String, HashSet<Annotation>> m = new HashMap<String, HashSet<Annotation>>();
        HashSet<String> s = new HashSet<String>();
        try {
            PropertyDescriptor[] descs;
            for (PropertyDescriptor desc : descs = Introspector.getBeanInfo(this.thisClass).getPropertyDescriptors()) {
                Method write;
                String propName = desc.getName();
                Set<Annotation> constraints = new HashSet<Annotation>();
                Method read = desc.getReadMethod();
                if (read != null) {
                    this.addConstraints(constraints, this.thisClass, read.getName(), read.getParameterTypes());
                }
                if ((write = desc.getWriteMethod()) != null) {
                    this.addConstraints(constraints, this.thisClass, write.getName(), write.getParameterTypes());
                }
                if (!constraints.isEmpty()) {
                    constraints = Collections.unmodifiableSet(constraints);
                    s.add(propName);
                } else {
                    constraints = Collections.emptySet();
                }
                m.put(propName, (HashSet<Annotation>)constraints);
            }
        }
        catch (IntrospectionException e) {
            logger.error("Error while building constraints!", (Throwable)e);
        }
        this.propertyConstraintMap = !m.isEmpty() ? Collections.unmodifiableMap(m) : Collections.emptyMap();
        this.constrainedProperties = !s.isEmpty() ? Collections.unmodifiableSet(s) : Collections.emptySet();
    }

    private void addConstraints(Set<Annotation> constraints, Class<?> thisClass, String methodName, Class<?>[] methodParameterTypes) {
        assert (constraints != null);
        assert (thisClass != null);
        assert (methodName != null);
        assert (methodParameterTypes != null);
        try {
            Method method = thisClass.getDeclaredMethod(methodName, methodParameterTypes);
            this.addConstraints(constraints, method.getAnnotations());
        }
        catch (NoSuchMethodException method) {
            // empty catch block
        }
        Class<?> superClass = thisClass.getSuperclass();
        if (superClass != null) {
            this.addConstraints(constraints, superClass, methodName, methodParameterTypes);
        }
    }

    private void addConstraints(Set<Annotation> constraints, Annotation[] annotations) {
        assert (constraints != null);
        assert (annotations != null);
        for (Annotation a : annotations) {
            if (!ConstrainedClass.isConstraint(a)) continue;
            constraints.add(a);
        }
    }
}

