/*
 * This file is part of JBizMo, a set of tools, libraries and plug-ins
 * for modeling and creating Java-based enterprise applications.
 * For more information visit:
 *
 * http://sourceforge.net/projects/jbizmo/
 *
 * This software is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package net.sourceforge.jbizmo.commons.exchange;

import net.sourceforge.jbizmo.commons.exception.ExceptionHelper;

/**
 * <p>
 * Exception thrown by data exchange methods if an import operation fails
 * </p>
 * <p>
 * Copyright 2013 (C) by Martin Ganserer
 * </p>
 * @author Martin Ganserer
 * @version 1.0.0
 */
public class DataImportException extends RuntimeException
{
	private static final long serialVersionUID = 1091962386771396708L;

	/**
	 * Constructor
	 * @param message
	 */
	public DataImportException(String message)
	{
		super(message);
	}

	/**
	 * Constructor
	 * @param cause the cause of the exception
	 */
	public DataImportException(Throwable cause)
	{
		super(cause);
	}

	/**
	 * Constructor
	 * @param message the error message
	 * @param cause the cause of the exception
	 */
	public DataImportException(String message, Throwable cause)
	{
		super(message, cause);
	}

	/**
	 * Constructor that initializes the exception with the message of the root cause
	 * @param cause the cause of the exception
	 * @param extractRootCauseMessage is only necessary to have a different method signature
	 */
	@SuppressWarnings("unused")
	public DataImportException(Throwable cause, boolean extractRootCauseMessage)
	{
		super(ExceptionHelper.getRootCause(cause).getMessage());
	}

}
