/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.validation;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sourceforge.jbizmo.commons.validation.PropertyConstraintViolationException;
import net.sourceforge.jbizmo.commons.validation.util.ConstrainedClass;
import net.sourceforge.jbizmo.commons.validation.util.ConstraintViolation;
import net.sourceforge.jbizmo.commons.validation.util.validator.ConstraintValidator;
import net.sourceforge.jbizmo.commons.validation.util.validator.ValidatorFactory;

public class BeanValidator {
    private final ConstrainedClass constrainedClass;
    private final Object validationTarget;

    public BeanValidator(Object validationTarget) {
        if (validationTarget == null) {
            throw new IllegalArgumentException("NULL is not a legal value for validationTarget");
        }
        this.validationTarget = validationTarget;
        this.constrainedClass = ConstrainedClass.getConstrainedClass(validationTarget.getClass());
    }

    public ConstrainedClass getConstrainedClass() {
        return this.constrainedClass;
    }

    public void validate() {
        Set<String> properties = this.constrainedClass.getConstrainedProperties();
        StringBuilder b = new StringBuilder();
        boolean isFirstViolation = true;
        for (String propertyName : properties) {
            try {
                List<ConstraintViolation> violations = this.validateProperty(this.constrainedClass, propertyName, this.getValue(propertyName));
                for (ConstraintViolation v : violations) {
                    if (isFirstViolation) {
                        isFirstViolation = false;
                    } else {
                        b.append("\n");
                    }
                    b.append(v.getMessage());
                }
            }
            catch (IntrospectionException e) {
                assert (false) : "Unexpected Error " + e.getMessage();
            }
        }
        if (b.length() != 0) {
            throw new PropertyConstraintViolationException(b.toString());
        }
    }

    public List<ConstraintViolation> validateProperty(ConstrainedClass constrainedClass, String propertyName, Object value) throws IntrospectionException {
        if (constrainedClass == null) {
            throw new IllegalArgumentException("null is not a legal value for constrainedClass");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("null is not a legal value for propertyName");
        }
        Set<Annotation> constraints = constrainedClass.getConstraints(propertyName);
        return BeanValidator.checkConstraints(value, constraints);
    }

    public static List<ConstraintViolation> checkConstraints(Object value, Set<Annotation> annotations) {
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        annotations.forEach(a -> {
            ConstraintViolation violation;
            ConstraintValidator v = ValidatorFactory.getInstance().getValidatorFor(a.annotationType());
            if (v != null && (violation = v.validate(value, (Annotation)a)) != null) {
                violations.add(violation);
            }
        });
        return violations;
    }

    private Object getValue(String propertyName) throws IntrospectionException {
        assert (propertyName != null);
        try {
            PropertyDescriptor[] descs;
            for (PropertyDescriptor desc : descs = Introspector.getBeanInfo(this.validationTarget.getClass()).getPropertyDescriptors()) {
                if (!desc.getName().equals(propertyName)) continue;
                Method read = desc.getReadMethod();
                if (read == null) {
                    throw new IntrospectionException(propertyName);
                }
                return read.invoke(this.validationTarget, (Object[])null);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IntrospectionException(propertyName);
        }
        throw new IntrospectionException(propertyName);
    }
}

