/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.search.dto;

import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import net.sourceforge.jbizmo.commons.search.dto.FilterOperatorEnum;
import net.sourceforge.jbizmo.commons.search.dto.SearchInputField;
import net.sourceforge.jbizmo.commons.search.dto.SortDirectionEnum;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SearchInput
implements Serializable {
    private static final long serialVersionUID = -5129142329127694576L;
    private static final int DEFAULT_FETCH_SIZE = 50;
    @XmlAttribute
    private int maxResult = 50;
    @XmlAttribute
    private boolean caseSensitive;
    @XmlAttribute
    private String numberFormat;
    @XmlAttribute
    private String dateFormat;
    @XmlAttribute
    private int startIndex;
    @XmlElement
    private List<SearchInputField> searchFields = new ArrayList<SearchInputField>();
    @XmlAttribute
    private String dateTimeFormat;
    @XmlAttribute
    private boolean exactFilterMatch = true;
    @XmlAttribute
    private char decimalSeparator;
    @XmlAttribute
    private char groupingSeparator;

    public SearchInput() {
        this.setDecimalSeparator(DecimalFormatSymbols.getInstance().getDecimalSeparator());
        this.setGroupingSeparator(DecimalFormatSymbols.getInstance().getGroupingSeparator());
    }

    public void addSearchField(String name, FilterOperatorEnum operator) {
        this.searchFields.add(new SearchInputField(name, operator));
    }

    public void addSearchField(String name, FilterOperatorEnum operator, String filterCriteria) {
        this.searchFields.add(new SearchInputField(name, operator, filterCriteria));
    }

    public void addSearchField(String name, FilterOperatorEnum operator, String filterCriteria, SortDirectionEnum sortOrder) {
        this.searchFields.add(new SearchInputField(name, operator, filterCriteria, sortOrder));
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public int getMaxResult() {
        return this.maxResult;
    }

    public void setMaxResult(int maxResult) {
        this.maxResult = maxResult;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
    }

    public List<SearchInputField> getSearchFields() {
        return this.searchFields;
    }

    public void setSearchFields(List<SearchInputField> searchFields) {
        this.searchFields = searchFields;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public boolean isExactFilterMatch() {
        return this.exactFilterMatch;
    }

    public void setExactFilterMatch(boolean exactFilterMatch) {
        this.exactFilterMatch = exactFilterMatch;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public void setGroupingSeparator(char groupingSeparator) {
        this.groupingSeparator = groupingSeparator;
    }
}

