/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.search.dto;

import java.io.Serializable;
import java.util.HashMap;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldDataTypeEnum;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldTypeEnum;
import net.sourceforge.jbizmo.commons.search.dto.SearchOperatorDTO;
import net.sourceforge.jbizmo.commons.search.dto.SortDirectionEnum;

public class SearchFieldDTO
implements Serializable,
Comparable<SearchFieldDTO> {
    private static final long serialVersionUID = 1L;
    private SearchOperatorDTO operator;
    private String filterCriteria;
    private int fetchIndex;
    private boolean visible = true;
    private SearchFieldTypeEnum type;
    private SearchFieldDataTypeEnum dataType;
    private String colLabel;
    private String colName;
    private int colWidth;
    private int colOrder;
    private SortDirectionEnum sortOrder;
    private String listOfValues;
    private int columnIndex = -1;
    private int sortIndex;
    private int originalColumnIndex;
    private HashMap<String, String> enumListValues;
    private String lovCommand;
    private boolean dateTimeFormat = true;

    public SearchFieldDTO() {
    }

    public SearchFieldDTO(int colDisplayOrder, String colName, String colLabel, SearchFieldDataTypeEnum dataType, int width) {
        this.colOrder = colDisplayOrder;
        this.colName = colName;
        this.colLabel = colLabel;
        this.dataType = dataType;
        this.type = SearchFieldTypeEnum.STANDARD;
        this.colWidth = width;
        this.setSortOrder(SortDirectionEnum.NONE);
        this.originalColumnIndex = this.colOrder;
    }

    public SearchFieldDTO(SearchFieldTypeEnum type, int colDisplayOrder, String colName, String colLabel, SearchFieldDataTypeEnum dataType, int width) {
        this.colOrder = colDisplayOrder;
        this.colName = colName;
        this.colLabel = colLabel;
        this.dataType = dataType;
        this.type = type;
        this.colWidth = width;
        this.setSortOrder(SortDirectionEnum.NONE);
        this.originalColumnIndex = this.colOrder;
    }

    public SearchFieldDTO(SearchFieldTypeEnum type, int colDisplayOrder, String colName, String colLabel, SearchFieldDataTypeEnum dataType, int width, String lov) {
        this.colOrder = colDisplayOrder;
        this.colName = colName;
        this.colLabel = colLabel;
        this.dataType = dataType;
        this.type = type;
        this.colWidth = width;
        this.setSortOrder(SortDirectionEnum.NONE);
        this.setListOfValues(lov);
        this.originalColumnIndex = this.colOrder;
    }

    public String getListOfValues() {
        return this.listOfValues;
    }

    public void setListOfValues(String listOfValues) {
        this.listOfValues = listOfValues;
    }

    @Override
    public int compareTo(SearchFieldDTO o) {
        return this.colOrder - o.colOrder;
    }

    public int getColOrder() {
        return this.colOrder;
    }

    public void setColOrder(int colDisplayOrder) {
        this.colOrder = colDisplayOrder;
    }

    public int getColWidth() {
        return this.colWidth;
    }

    public void setColWidth(int colWidth) {
        this.colWidth = colWidth;
    }

    public String getColLabel() {
        return this.colLabel;
    }

    public void setColLabel(String colLabel) {
        this.colLabel = colLabel;
    }

    public String getColName() {
        return this.colName;
    }

    public void setColName(String colName) {
        this.colName = colName;
    }

    public SearchFieldDataTypeEnum getDataType() {
        return this.dataType;
    }

    public void setDataType(SearchFieldDataTypeEnum type) {
        this.dataType = type;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getFetchIndex() {
        return this.fetchIndex;
    }

    public void setFetchIndex(int colIndex) {
        this.fetchIndex = colIndex;
    }

    public SearchOperatorDTO getOperator() {
        return this.operator;
    }

    public void setOperator(SearchOperatorDTO operator) {
        this.operator = operator;
    }

    public String getFilterCriteria() {
        return this.filterCriteria;
    }

    public void setFilterCriteria(String filterCriteria) {
        this.filterCriteria = filterCriteria;
    }

    public SortDirectionEnum getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortDirectionEnum sortOrder) {
        this.sortOrder = sortOrder;
    }

    public SearchFieldTypeEnum getType() {
        return this.type;
    }

    public void setType(SearchFieldTypeEnum type) {
        this.type = type;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public int getOriginalColumnIndex() {
        return this.originalColumnIndex;
    }

    public void setOriginalColumnIndex(int originalColumnIndex) {
        this.originalColumnIndex = originalColumnIndex;
    }

    public HashMap<String, String> getEnumListValues() {
        return this.enumListValues;
    }

    public void setEnumListValues(HashMap<String, String> enumListValues) {
        this.enumListValues = enumListValues;
    }

    public String getLovCommand() {
        return this.lovCommand;
    }

    public void setLovCommand(String lovCommand) {
        this.lovCommand = lovCommand;
    }

    public boolean isDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(boolean dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }
}

