/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MethodFinder {
    private MethodFinder() {
    }

    public static Method findMethod(Class<?> cl, String methodName, Object[] params) throws NoSuchMethodException {
        Method[] methods;
        HashMap<String, ArrayList<Method>> methodMap = new HashMap<String, ArrayList<Method>>();
        HashMap<Method, Class<?>[]> paramMap = new HashMap<Method, Class<?>[]>();
        for (Method method : methods = cl.getMethods()) {
            String mName = method.getName();
            ArrayList<Method> methodList = (ArrayList<Method>)methodMap.get(mName);
            if (methodList == null) {
                methodList = new ArrayList<Method>();
                methodMap.put(mName, methodList);
            }
            methodList.add(method);
            Class<?>[] paramTypes = method.getParameterTypes();
            paramMap.put(method, paramTypes);
        }
        List methodList = (List)methodMap.get(methodName);
        if (methodList == null) {
            throw new NoSuchMethodException(methodName);
        }
        for (int i = 0; i < methodList.size(); ++i) {
            Method m = (Method)methodList.get(i);
            boolean ok = true;
            Class[] paramTypes = (Class[])paramMap.get(m);
            if (params == null) {
                params = new Object[]{};
            }
            if (paramTypes.length != params.length) continue;
            for (int j = 0; j < paramTypes.length; ++j) {
                if (params[j] == null) continue;
                Class<?> c = params[j].getClass();
                Class paramClass = paramTypes[j];
                if (paramClass.isPrimitive()) {
                    if (paramClass.equals(Integer.TYPE)) {
                        if (c.equals(Integer.class)) continue;
                        ok = false;
                        break;
                    }
                    if (paramClass.equals(Double.TYPE)) {
                        if (c.equals(Double.class)) continue;
                        ok = false;
                        break;
                    }
                    if (paramClass.equals(Boolean.TYPE)) {
                        if (c.equals(Boolean.class)) continue;
                        ok = false;
                        break;
                    }
                    if (paramClass.equals(Long.TYPE)) {
                        if (c.equals(Long.class)) continue;
                        ok = false;
                        break;
                    }
                    if (paramClass.equals(Character.TYPE)) {
                        if (c.equals(Character.class)) continue;
                        ok = false;
                        break;
                    }
                    if (paramClass.equals(Byte.TYPE)) {
                        if (c.equals(Byte.class)) continue;
                        ok = false;
                        break;
                    }
                    if (paramClass.equals(Float.TYPE)) {
                        if (c.equals(Float.class)) continue;
                        ok = false;
                        break;
                    }
                    if (!paramClass.equals(Short.TYPE)) break;
                    if (c.equals(Short.class)) continue;
                    ok = false;
                    break;
                }
                if (paramClass.isAssignableFrom(c)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return m;
        }
        throw new NoSuchMethodException(methodName);
    }
}

