/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.property;

import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import net.sourceforge.jbizmo.commons.property.IllegalPropertyValueException;

public class PropertyService {
    public static final String PROP_LOGGING_LEVEL = "logging_level";
    public static final String PROP_EXCHANGE_FOLDER = "exchange_folder";
    public static final String PROP_REPOSITORY_FOLDER = "document_repository_folder";
    private static final String DEFAULT_PATH = "config/application.properties";
    private static final String DATE_FORMAT = "dd.MM.yyyy HH:mm:ss";
    private static final String DECIMAL_FORMAT = "0.00";
    private boolean propertiesLoaded;
    private Properties properties;
    private String pathToFile = "config/application.properties";

    public PropertyService() {
    }

    public PropertyService(String pathToFile) {
        this.pathToFile = pathToFile;
    }

    private String getProperty(String name) {
        if (!this.propertiesLoaded) {
            this.loadProperties();
        }
        if (this.properties.getProperty(name) == null) {
            throw new IllegalPropertyValueException("Property " + name + " does not exist!");
        }
        return this.properties.getProperty(name);
    }

    public String getStringProperty(String name) {
        return this.getProperty(name);
    }

    public int getIntProperty(String name) {
        String propertyValue = this.getProperty(name);
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid integer value!");
        }
    }

    public long getLongProperty(String name) {
        String propertyValue = this.getProperty(name);
        try {
            return Long.parseLong(propertyValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid long value!");
        }
    }

    public double getDoubleProperty(String name) {
        String propertyValue = this.getProperty(name);
        DecimalFormat decimalFormat = new DecimalFormat(DECIMAL_FORMAT);
        try {
            Number n = decimalFormat.parse(propertyValue);
            return n.doubleValue();
        }
        catch (ParseException e) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid double value!");
        }
    }

    public float getFloatProperty(String name) {
        String propertyValue = this.getProperty(name);
        DecimalFormat decimalFormat = new DecimalFormat(DECIMAL_FORMAT);
        try {
            Number n = decimalFormat.parse(propertyValue);
            return n.floatValue();
        }
        catch (ParseException e) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid float value!");
        }
    }

    public char getCharProperty(String name) {
        String propertyValue = this.getProperty(name);
        if (propertyValue.isEmpty() || propertyValue.length() > 1) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid character value!");
        }
        return propertyValue.charAt(0);
    }

    public synchronized Date getDateProperty(String name) {
        String propertyValue = this.getProperty(name);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        try {
            return dateFormat.parse(propertyValue);
        }
        catch (ParseException e) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid java.util.Date value!");
        }
    }

    public boolean getBooleanProperty(String name) {
        String propertyValue = this.getProperty(name);
        return Boolean.parseBoolean(propertyValue);
    }

    private synchronized void loadProperties() {
        InputStream inputStream = PropertyService.class.getClassLoader().getResourceAsStream(this.pathToFile);
        if (inputStream == null) {
            throw new IllegalStateException("Failed to load properties from specified location!");
        }
        try {
            this.properties = new Properties();
            this.properties.load(inputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while loading properties! Message: " + e.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.propertiesLoaded = true;
    }
}

