/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import net.sourceforge.jbizmo.commons.property.PropertyService;

public class FileUtil {
    private static final String CURRENT_WORKING_DIRECTORY = System.getProperty("user.dir");
    private static final PropertyService propertyService = new PropertyService();

    private FileUtil() {
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        Files.copy(sourceFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static synchronized String getUniqueFileName(String groupName) {
        String repositoryPath = propertyService.getStringProperty("document_repository_folder");
        String fileName = groupName + "_" + System.nanoTime();
        if (repositoryPath.isEmpty()) {
            repositoryPath = CURRENT_WORKING_DIRECTORY;
        }
        repositoryPath = repositoryPath.endsWith(File.separator) ? repositoryPath + fileName : repositoryPath + File.separator + fileName;
        return repositoryPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = null;
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File " + file.getName() + " is too large!");
        }
        try {
            int offset;
            is = new FileInputStream(file);
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        return bytes;
    }

    public static Byte[] convertToByteArray(byte[] array) {
        Byte[] returnArray = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            returnArray[i] = array[i];
        }
        return returnArray;
    }

    public static byte[] convertToByteArray(Byte[] array) {
        byte[] returnArray = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            returnArray[i] = array[i];
        }
        return returnArray;
    }
}

