/*
 * This file is part of JBizMo, a set of tools, libraries and plug-ins
 * for modeling and creating Java-based enterprise applications.
 * For more information visit:
 *
 * http://sourceforge.net/projects/jbizmo/
 *
 * This software is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package net.sourceforge.jbizmo.commons.i18n;

import java.text.MessageFormat;
import java.util.ResourceBundle;

/**
 * <p>
 * Utility class for translation of text fragments
 * </p>
 * <p>
 * Copyright 2017 (C) by Martin Ganserer
 * </p>
 * @author Martin Ganserer
 * @version 1.0.0
 */
public class I18N
{
	public static final String LABEL_SEPARATOR = ":";

	/**
	 * Prevent instantiation
	 */
	private I18N()
	{

	}

	/**
	 * @param resourceBoundle
	 * @param key
	 * @return the translation text from the given resource bundle by using the given key
	 */
	public static String getTranslation(ResourceBundle resourceBoundle, String key)
	{
		try
		{
			return resourceBoundle.getString(key);
		}
		catch (final Exception e)
		{
			e.printStackTrace();

			return "???-" + key + "-???";
		}
	}

	/**
	 * @param resourceBoundle
	 * @param key
	 * @param params
	 * @return the translation text from the given resource bundle by using the given key
	 */
	public static String getTranslation(ResourceBundle resourceBoundle, String key, Object... params)
	{
		String msg = getTranslation(resourceBoundle, key);

		if(params != null)
		{
			final MessageFormat format = new MessageFormat(msg);
			msg = format.format(params);
		}

		return msg;
	}

	/**
	 * @param resourceBoundle
	 * @param key
	 * @return the translation for a field label from the given resource bundle by using the given key
	 */
	public static String getTranslationForFieldLabel(ResourceBundle resourceBoundle, String key)
	{
		return getTranslation(resourceBoundle, key) + LABEL_SEPARATOR;
	}

}
