/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.validation.util.validator;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jbizmo.commons.validation.FutureDate;
import net.sourceforge.jbizmo.commons.validation.MaxDecimalValue;
import net.sourceforge.jbizmo.commons.validation.MaxFloatValue;
import net.sourceforge.jbizmo.commons.validation.MaxIntegerValue;
import net.sourceforge.jbizmo.commons.validation.MaxLength;
import net.sourceforge.jbizmo.commons.validation.MinDecimalValue;
import net.sourceforge.jbizmo.commons.validation.MinFloatValue;
import net.sourceforge.jbizmo.commons.validation.MinIntegerValue;
import net.sourceforge.jbizmo.commons.validation.MinLength;
import net.sourceforge.jbizmo.commons.validation.NotEmpty;
import net.sourceforge.jbizmo.commons.validation.NotNull;
import net.sourceforge.jbizmo.commons.validation.PastDate;
import net.sourceforge.jbizmo.commons.validation.RegularExpression;
import net.sourceforge.jbizmo.commons.validation.util.validator.ConstraintValidator;
import net.sourceforge.jbizmo.commons.validation.util.validator.FutureDateValidator;
import net.sourceforge.jbizmo.commons.validation.util.validator.MaxDecimalValueValidator;
import net.sourceforge.jbizmo.commons.validation.util.validator.MaxFloatValueValidator;
import net.sourceforge.jbizmo.commons.validation.util.validator.MaxIntegerValueValidator;
import net.sourceforge.jbizmo.commons.validation.util.validator.MaxLengthValidator;
import net.sourceforge.jbizmo.commons.validation.util.validator.MinDecimalValueValidator;
import net.sourceforge.jbizmo.commons.validation.util.validator.MinFloatValueValidator;
import net.sourceforge.jbizmo.commons.validation.util.validator.MinIntegerValueValidator;
import net.sourceforge.jbizmo.commons.validation.util.validator.MinLengthValidator;
import net.sourceforge.jbizmo.commons.validation.util.validator.NotEmptyValidator;
import net.sourceforge.jbizmo.commons.validation.util.validator.NotNullValidator;
import net.sourceforge.jbizmo.commons.validation.util.validator.PastDateValidator;
import net.sourceforge.jbizmo.commons.validation.util.validator.RegularExpressionValidator;

public class ValidatorFactory {
    private static ValidatorFactory instance = new ValidatorFactory();
    private final Map<Class<? extends Annotation>, ConstraintValidator> validators = new HashMap<Class<? extends Annotation>, ConstraintValidator>();

    private ValidatorFactory() {
        this.register(NotNull.class, new NotNullValidator());
        this.register(MinLength.class, new MinLengthValidator());
        this.register(MaxLength.class, new MaxLengthValidator());
        this.register(RegularExpression.class, new RegularExpressionValidator());
        this.register(PastDate.class, new PastDateValidator());
        this.register(FutureDate.class, new FutureDateValidator());
        this.register(MaxIntegerValue.class, new MaxIntegerValueValidator());
        this.register(MinIntegerValue.class, new MinIntegerValueValidator());
        this.register(MinFloatValue.class, new MinFloatValueValidator());
        this.register(MaxFloatValue.class, new MaxFloatValueValidator());
        this.register(MinDecimalValue.class, new MinDecimalValueValidator());
        this.register(MaxDecimalValue.class, new MaxDecimalValueValidator());
        this.register(NotEmpty.class, new NotEmptyValidator());
    }

    public static ValidatorFactory getInstance() {
        return instance;
    }

    public ConstraintValidator getValidatorFor(Class<? extends Annotation> constraintType) {
        return this.validators.get(constraintType);
    }

    public void register(Class<? extends Annotation> constraintType, ConstraintValidator validator) {
        this.validators.put(constraintType, validator);
    }
}

