/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.validation.util.validator;

import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.GregorianCalendar;
import net.sourceforge.jbizmo.commons.validation.FutureDate;
import net.sourceforge.jbizmo.commons.validation.util.ConstraintViolation;
import net.sourceforge.jbizmo.commons.validation.util.validator.ConstraintValidator;

public class FutureDateValidator
implements ConstraintValidator {
    @Override
    public ConstraintViolation validate(Object objValue, Annotation constraint) {
        ConstraintViolation result = null;
        FutureDate c = (FutureDate)constraint;
        if (objValue != null) {
            long dateValue = 0L;
            long currentDateValue = 0L;
            if (objValue instanceof Date) {
                dateValue = ((Date)objValue).getTime();
                currentDateValue = new Date().getTime();
            } else if (objValue instanceof GregorianCalendar) {
                dateValue = ((GregorianCalendar)objValue).getTimeInMillis();
                currentDateValue = new GregorianCalendar().getTimeInMillis();
            } else {
                return null;
            }
            if (dateValue <= currentDateValue) {
                result = c.message() != null && !c.message().isEmpty() ? new ConstraintViolation(c.message()) : new ConstraintViolation("Date must be in the future!");
            }
        }
        return result;
    }
}

