/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.stream;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import net.sourceforge.jbizmo.commons.crypto.CipherFactory;

public class StreamWorker {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private final int bufferSize;

    public StreamWorker() {
        this(1024);
    }

    public StreamWorker(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToOutput(InputStream in, OutputStream out, boolean encryptOutput, boolean decryptInput) throws Exception {
        byte[] buf = new byte[this.bufferSize <= 0 ? 1024 : this.bufferSize];
        int numRead = 0;
        try {
            if (encryptOutput) {
                out = new CipherOutputStream(out, CipherFactory.getEncryptionCipher());
            }
            if (decryptInput) {
                in = new CipherInputStream(in, CipherFactory.getDecryptionCipher());
            }
            while ((numRead = in.read(buf)) >= 0) {
                out.write(buf, 0, numRead);
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObjectFromStream(InputStream in, boolean decrypt) throws Exception {
        try (ObjectInputStream ois = null;){
            ois = decrypt ? new ObjectInputStream(new CipherInputStream(in, CipherFactory.getDecryptionCipher())) : new ObjectInputStream(in);
            Object object = ois.readObject();
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObjectToStream(Serializable object, OutputStream out, boolean encrypt) throws Exception {
        try (ObjectOutputStream oos = null;){
            oos = encrypt ? new ObjectOutputStream(new CipherOutputStream(out, CipherFactory.getEncryptionCipher())) : new ObjectOutputStream(out);
            oos.writeObject(object);
        }
    }
}

