/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.search.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import net.sourceforge.jbizmo.commons.search.dto.SearchDTO;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldDTO;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldDataTypeEnum;
import net.sourceforge.jbizmo.commons.search.dto.SearchOperatorDTO;
import net.sourceforge.jbizmo.commons.search.dto.SortDirectionEnum;
import net.sourceforge.jbizmo.commons.search.exception.GeneralSearchException;

public class QueryHelper {
    public static final String WHERE = "where";
    public static final String SELECT = "select ";
    public static final String AND = " and ";
    public static final String ORDER_BY = " order by ";
    public static final String COUNT = "count(a) ";
    public static final String IN = " in (";
    public static final String BETWEEN = " between ";
    public static final String NOT_IN = " not in (";
    private static final String PARAM = "param";
    private static SearchOperatorDTO defaultOperatorEqual = new SearchOperatorDTO(0, "=", "equal", true, true, true, true, true);
    private static SearchOperatorDTO defaultOperatorLike = new SearchOperatorDTO(1, "like", "like", true, false, false, true, false);

    private static String addInStatement(SearchFieldDTO field, boolean exactMatch) {
        StringBuilder buf = new StringBuilder();
        if (field.getFilterCriteria().indexOf(";;") == -1) {
            return "";
        }
        buf.append(field.getColName());
        if (field.getOperator().getValue().equals("in")) {
            buf.append(IN);
        } else {
            buf.append(NOT_IN);
        }
        boolean isFirstToken = true;
        String[] tokens = field.getFilterCriteria().split(";;");
        int tokenIndex = 0;
        for (String token : tokens) {
            token = QueryHelper.removeIllegalCharacters(token);
            if (isFirstToken) {
                isFirstToken = false;
            } else {
                buf.append(",");
            }
            if (field.getDataType() == SearchFieldDataTypeEnum.STRING || field.getDataType() == SearchFieldDataTypeEnum.ENUM) {
                if (exactMatch) {
                    buf.append("'");
                    buf.append(token);
                    buf.append("'");
                    continue;
                }
                buf.append("'%");
                buf.append(token);
                buf.append("%'");
                continue;
            }
            if (field.getDataType() == SearchFieldDataTypeEnum.CHAR) {
                buf.append("'");
                buf.append(token);
                buf.append("'");
                continue;
            }
            if (field.getDataType() == SearchFieldDataTypeEnum.INTEGER || field.getDataType() == SearchFieldDataTypeEnum.LONG || field.getDataType() == SearchFieldDataTypeEnum.DOUBLE || field.getDataType() == SearchFieldDataTypeEnum.FLOAT || field.getDataType() == SearchFieldDataTypeEnum.BIG_DECIMAL) {
                buf.append(":param" + field.getColOrder() + "_" + tokenIndex++);
                continue;
            }
            buf.append(token);
        }
        buf.append(")");
        return buf.toString();
    }

    private static String addBetweenStatement(SearchFieldDTO field, boolean exactMatch) {
        StringBuilder buf = new StringBuilder();
        if (field.getFilterCriteria().indexOf("  ") == -1) {
            return "";
        }
        buf.append(field.getColName());
        buf.append(BETWEEN);
        if (field.getDataType() == SearchFieldDataTypeEnum.GREGORIAN_CALENDAR || field.getDataType() == SearchFieldDataTypeEnum.DATE || field.getDataType() == SearchFieldDataTypeEnum.FLOAT || field.getDataType() == SearchFieldDataTypeEnum.DOUBLE || field.getDataType() == SearchFieldDataTypeEnum.INTEGER || field.getDataType() == SearchFieldDataTypeEnum.LONG || field.getDataType() == SearchFieldDataTypeEnum.BIG_DECIMAL) {
            buf.append(":");
            buf.append(PARAM);
            buf.append(field.getColOrder() + "1");
            buf.append(AND);
            buf.append(" :");
            buf.append(PARAM);
            buf.append(field.getColOrder() + "2");
            return buf.toString();
        }
        String value1 = field.getFilterCriteria().substring(0, field.getFilterCriteria().indexOf("  "));
        String value2 = field.getFilterCriteria().substring(field.getFilterCriteria().indexOf("  ") + "  ".length());
        value1 = QueryHelper.removeIllegalCharacters(value1);
        value2 = QueryHelper.removeIllegalCharacters(value2);
        if (field.getDataType() == SearchFieldDataTypeEnum.STRING || field.getDataType() == SearchFieldDataTypeEnum.ENUM) {
            if (exactMatch) {
                buf.append("'");
                buf.append(value1);
                buf.append("'");
                buf.append(AND);
                buf.append("'");
                buf.append(value2);
                buf.append("'");
            } else {
                buf.append("'%");
                buf.append(value1);
                buf.append("%'");
                buf.append(AND);
                buf.append("'%");
                buf.append(value2);
                buf.append("%'");
            }
        } else if (field.getDataType() == SearchFieldDataTypeEnum.CHAR) {
            buf.append("'");
            buf.append(value1);
            buf.append("'");
            buf.append(AND);
            buf.append("'");
            buf.append(value2);
            buf.append("'");
        } else {
            buf.append(value1);
            buf.append(AND);
            buf.append(value2);
        }
        return buf.toString();
    }

    private static String addField(SearchFieldDTO field, boolean whereSet, boolean caseSensitive, boolean exactMatch) {
        StringBuilder buf = new StringBuilder();
        SearchOperatorDTO op = null;
        if (whereSet) {
            buf.append(AND);
        } else {
            buf.append(" ");
            buf.append(WHERE);
            buf.append(" ");
        }
        op = field.getOperator() == null ? (field.getDataType() == SearchFieldDataTypeEnum.STRING || field.getDataType() == SearchFieldDataTypeEnum.ENUM ? defaultOperatorLike : defaultOperatorEqual) : field.getOperator();
        if (op.getValue().equals("is null") || op.getValue().equals("is not null")) {
            buf.append(field.getColName());
            buf.append(" ");
            buf.append(op.getValue());
            buf.append(" ");
        } else if (op.getValue().equals("between")) {
            buf.append(QueryHelper.addBetweenStatement(field, exactMatch));
        } else if (op.getValue().equals("in") || op.getValue().equals("not in")) {
            buf.append(QueryHelper.addInStatement(field, exactMatch));
        } else if (field.getDataType() == SearchFieldDataTypeEnum.STRING || field.getDataType() == SearchFieldDataTypeEnum.ENUM) {
            if (caseSensitive) {
                if (exactMatch || op.getValue().equals("=")) {
                    buf.append(field.getColName());
                    buf.append(" ");
                    buf.append(op.getValue());
                    buf.append(" '");
                    buf.append(QueryHelper.removeIllegalCharacters(field.getFilterCriteria()));
                    buf.append("'");
                } else {
                    buf.append(field.getColName());
                    buf.append(" ");
                    buf.append(op.getValue());
                    buf.append(" '%");
                    buf.append(QueryHelper.removeIllegalCharacters(field.getFilterCriteria()));
                    buf.append("%'");
                }
            } else if (exactMatch || op.getValue().equals("=")) {
                buf.append("lower(");
                buf.append(field.getColName());
                buf.append(") ");
                buf.append(op.getValue());
                buf.append(" '");
                buf.append(QueryHelper.removeIllegalCharacters(field.getFilterCriteria()).toLowerCase());
                buf.append("'");
            } else {
                buf.append("lower(");
                buf.append(field.getColName());
                buf.append(") ");
                buf.append(op.getValue());
                buf.append(" '%");
                buf.append(QueryHelper.removeIllegalCharacters(field.getFilterCriteria().toLowerCase()));
                buf.append("%'");
            }
        } else if (field.getDataType() == SearchFieldDataTypeEnum.DATE || field.getDataType() == SearchFieldDataTypeEnum.GREGORIAN_CALENDAR || field.getDataType() == SearchFieldDataTypeEnum.FLOAT || field.getDataType() == SearchFieldDataTypeEnum.DOUBLE || field.getDataType() == SearchFieldDataTypeEnum.INTEGER || field.getDataType() == SearchFieldDataTypeEnum.LONG || field.getDataType() == SearchFieldDataTypeEnum.BIG_DECIMAL) {
            buf.append(field.getColName());
            buf.append(" ");
            buf.append(op.getValue());
            buf.append(" :");
            buf.append(PARAM);
            buf.append(field.getColOrder());
        } else if (field.getDataType() == SearchFieldDataTypeEnum.CHAR) {
            if (caseSensitive) {
                buf.append(field.getColName());
                buf.append(" ");
                buf.append(op.getValue());
                buf.append(" '");
                buf.append(QueryHelper.removeIllegalCharacters(field.getFilterCriteria()));
                buf.append("'");
            } else {
                buf.append("lower(");
                buf.append(field.getColName());
                buf.append(") ");
                buf.append(op.getValue());
                buf.append(" '");
                buf.append(QueryHelper.removeIllegalCharacters(field.getFilterCriteria()).toLowerCase());
                buf.append("'");
            }
        } else {
            buf.append(field.getColName());
            buf.append(" ");
            buf.append(op.getValue());
            buf.append(" ");
            buf.append(QueryHelper.removeIllegalCharacters(field.getFilterCriteria()));
        }
        return buf.toString();
    }

    private static GregorianCalendar parseCalendar(String date, String format) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date paramDate = dateFormat.parse(date);
        GregorianCalendar calParam = new GregorianCalendar();
        calParam.setTime(paramDate);
        return calParam;
    }

    private static Date parseDate(String date, String format) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.parse(date);
    }

    private static float parseFloat(String floatValue, SearchDTO searchObj) throws ParseException {
        DecimalFormatSymbols decimalSymbols = new DecimalFormatSymbols();
        decimalSymbols.setDecimalSeparator(searchObj.getDecimalSeparator());
        decimalSymbols.setGroupingSeparator(searchObj.getGroupingSeparator());
        DecimalFormat decimalFormat = new DecimalFormat(searchObj.getNumberFormat(), decimalSymbols);
        return decimalFormat.parse(floatValue).floatValue();
    }

    private static double parseDouble(String doubleValue, SearchDTO searchObj) throws ParseException {
        DecimalFormatSymbols decimalSymbols = new DecimalFormatSymbols();
        decimalSymbols.setDecimalSeparator(searchObj.getDecimalSeparator());
        decimalSymbols.setGroupingSeparator(searchObj.getGroupingSeparator());
        DecimalFormat decimalFormat = new DecimalFormat(searchObj.getNumberFormat(), decimalSymbols);
        return decimalFormat.parse(doubleValue).doubleValue();
    }

    private static BigDecimal parseBigDecimal(String decimalValue, SearchDTO searchObj) throws ParseException {
        DecimalFormatSymbols decimalSymbols = new DecimalFormatSymbols();
        decimalSymbols.setDecimalSeparator(searchObj.getDecimalSeparator());
        decimalSymbols.setGroupingSeparator(searchObj.getGroupingSeparator());
        DecimalFormat decimalFormat = new DecimalFormat(searchObj.getNumberFormat(), decimalSymbols);
        decimalFormat.setParseBigDecimal(true);
        return (BigDecimal)decimalFormat.parse(decimalValue);
    }

    public static String createStatement(SearchDTO searchDTO) throws GeneralSearchException {
        StringBuffer statement = new StringBuffer();
        boolean whereSet = false;
        StringBuffer orderBy = new StringBuffer();
        String defaultOrderBy = "";
        try {
            if (searchDTO.getFromClause().indexOf(WHERE) != -1) {
                whereSet = true;
            }
            if (searchDTO.getFromClause().indexOf(ORDER_BY) != -1) {
                defaultOrderBy = searchDTO.getFromClause().substring(searchDTO.getFromClause().indexOf(ORDER_BY));
                String fromClause = searchDTO.getFromClause().substring(0, searchDTO.getFromClause().indexOf(ORDER_BY));
                statement.append(fromClause);
            } else {
                statement.append(searchDTO.getFromClause());
            }
            for (SearchFieldDTO field : searchDTO.getSearchFields()) {
                if (field.getOperator() == null && (field.getFilterCriteria() == null || field.getFilterCriteria().isEmpty())) continue;
                statement.append(QueryHelper.addField(field, whereSet, searchDTO.isCaseSensitive(), searchDTO.isExactFilterMatch()));
                whereSet = true;
            }
            if (searchDTO.getGroupBy() != null && !searchDTO.getGroupBy().isEmpty()) {
                statement.append(" " + searchDTO.getGroupBy());
            }
            boolean isFirstOrderBy = true;
            if (!defaultOrderBy.isEmpty()) {
                isFirstOrderBy = false;
                orderBy.append(defaultOrderBy);
            }
            Collections.sort(searchDTO.getSearchFields(), new Comparator<SearchFieldDTO>(){

                @Override
                public int compare(SearchFieldDTO a, SearchFieldDTO b) {
                    Integer index1 = a.getSortIndex();
                    Integer index2 = b.getSortIndex();
                    return index1.compareTo(index2);
                }
            });
            for (SearchFieldDTO field : searchDTO.getSearchFields()) {
                if (field.getSortOrder() == SortDirectionEnum.NONE) continue;
                if (!isFirstOrderBy) {
                    orderBy.append(",");
                } else {
                    statement.append(ORDER_BY);
                    isFirstOrderBy = false;
                }
                orderBy.append(field.getColName());
                orderBy.append(" ");
                orderBy.append(field.getSortOrder().name().toLowerCase());
            }
            if (!isFirstOrderBy) {
                statement.append(orderBy);
            }
            return statement.toString();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new GeneralSearchException(t, true);
        }
    }

    public static HashMap<String, Object> createParameters(SearchDTO searchDTO) throws ParseException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (SearchFieldDTO field : searchDTO.getSearchFields()) {
            if (field.getOperator() == null && (field.getFilterCriteria() == null || field.getFilterCriteria().isEmpty())) continue;
            QueryHelper.updateMap(params, field, searchDTO);
        }
        return params;
    }

    private static String removeIllegalCharacters(String criterion) {
        return criterion.replace("'", "").replace("\"", "");
    }

    private static void updateMap(HashMap<String, Object> params, SearchFieldDTO field, SearchDTO searchDTO) throws ParseException, NumberFormatException {
        SearchOperatorDTO op = null;
        SearchFieldDataTypeEnum dataType = field.getDataType();
        op = field.getOperator() == null ? (dataType == SearchFieldDataTypeEnum.STRING || dataType == SearchFieldDataTypeEnum.ENUM ? defaultOperatorLike : defaultOperatorEqual) : field.getOperator();
        if (!(dataType != SearchFieldDataTypeEnum.GREGORIAN_CALENDAR && dataType != SearchFieldDataTypeEnum.DATE && dataType != SearchFieldDataTypeEnum.DOUBLE && dataType != SearchFieldDataTypeEnum.FLOAT && dataType != SearchFieldDataTypeEnum.INTEGER && dataType != SearchFieldDataTypeEnum.LONG && dataType != SearchFieldDataTypeEnum.BIG_DECIMAL || op.getValue().equals("is null") || op.getValue().equals("is not null"))) {
            String format = dataType == SearchFieldDataTypeEnum.GREGORIAN_CALENDAR || dataType == SearchFieldDataTypeEnum.DATE ? (field.isDateTimeFormat() ? searchDTO.getDateTimeFormat() : searchDTO.getDateFormat()) : searchDTO.getNumberFormat();
            if (field.getFilterCriteria().indexOf("  ") != -1 && op.getValue().equals("between")) {
                String value1 = field.getFilterCriteria().substring(0, field.getFilterCriteria().indexOf("  "));
                String value2 = field.getFilterCriteria().substring(field.getFilterCriteria().lastIndexOf("  ") + "  ".length(), field.getFilterCriteria().length());
                if (dataType == SearchFieldDataTypeEnum.GREGORIAN_CALENDAR) {
                    params.put(PARAM + field.getColOrder() + "1", QueryHelper.parseCalendar(value1, format));
                    params.put(PARAM + field.getColOrder() + "2", QueryHelper.parseCalendar(value2, format));
                } else if (dataType == SearchFieldDataTypeEnum.DATE) {
                    params.put(PARAM + field.getColOrder() + "1", QueryHelper.parseDate(value1, format));
                    params.put(PARAM + field.getColOrder() + "2", QueryHelper.parseDate(value2, format));
                } else if (dataType == SearchFieldDataTypeEnum.FLOAT) {
                    params.put(PARAM + field.getColOrder() + "1", Float.valueOf(QueryHelper.parseFloat(value1, searchDTO)));
                    params.put(PARAM + field.getColOrder() + "2", Float.valueOf(QueryHelper.parseFloat(value2, searchDTO)));
                } else if (dataType == SearchFieldDataTypeEnum.DOUBLE) {
                    params.put(PARAM + field.getColOrder() + "1", QueryHelper.parseDouble(value1, searchDTO));
                    params.put(PARAM + field.getColOrder() + "2", QueryHelper.parseDouble(value2, searchDTO));
                } else if (dataType == SearchFieldDataTypeEnum.BIG_DECIMAL) {
                    params.put(PARAM + field.getColOrder() + "1", QueryHelper.parseBigDecimal(value1, searchDTO));
                    params.put(PARAM + field.getColOrder() + "2", QueryHelper.parseBigDecimal(value2, searchDTO));
                } else if (dataType == SearchFieldDataTypeEnum.INTEGER) {
                    params.put(PARAM + field.getColOrder() + "1", Integer.parseInt(value1));
                    params.put(PARAM + field.getColOrder() + "2", Integer.parseInt(value2));
                } else if (dataType == SearchFieldDataTypeEnum.LONG) {
                    params.put(PARAM + field.getColOrder() + "1", Long.parseLong(value1));
                    params.put(PARAM + field.getColOrder() + "2", Long.parseLong(value2));
                }
            } else if (field.getFilterCriteria().indexOf(";;") != -1 && (op.getValue().equals("in") || op.getValue().equals("not in"))) {
                String[] tokens = field.getFilterCriteria().split(";;");
                int tokenIndex = 0;
                for (String token : tokens) {
                    if (dataType == SearchFieldDataTypeEnum.FLOAT) {
                        params.put(PARAM + field.getColOrder() + "_" + tokenIndex++, Float.valueOf(QueryHelper.parseFloat(token, searchDTO)));
                        continue;
                    }
                    if (dataType == SearchFieldDataTypeEnum.DOUBLE) {
                        params.put(PARAM + field.getColOrder() + "_" + tokenIndex++, QueryHelper.parseDouble(token, searchDTO));
                        continue;
                    }
                    if (dataType == SearchFieldDataTypeEnum.BIG_DECIMAL) {
                        params.put(PARAM + field.getColOrder() + "_" + tokenIndex++, QueryHelper.parseBigDecimal(token, searchDTO));
                        continue;
                    }
                    if (dataType == SearchFieldDataTypeEnum.INTEGER) {
                        params.put(PARAM + field.getColOrder() + "_" + tokenIndex++, Integer.parseInt(token));
                        continue;
                    }
                    if (dataType != SearchFieldDataTypeEnum.LONG) continue;
                    params.put(PARAM + field.getColOrder() + "_" + tokenIndex++, Long.parseLong(token));
                }
            } else if (dataType == SearchFieldDataTypeEnum.GREGORIAN_CALENDAR) {
                params.put(PARAM + field.getColOrder(), QueryHelper.parseCalendar(field.getFilterCriteria(), format));
            } else if (dataType == SearchFieldDataTypeEnum.DATE) {
                params.put(PARAM + field.getColOrder(), QueryHelper.parseDate(field.getFilterCriteria(), format));
            } else if (dataType == SearchFieldDataTypeEnum.FLOAT) {
                params.put(PARAM + field.getColOrder(), Float.valueOf(QueryHelper.parseFloat(field.getFilterCriteria(), searchDTO)));
            } else if (dataType == SearchFieldDataTypeEnum.DOUBLE) {
                params.put(PARAM + field.getColOrder(), QueryHelper.parseDouble(field.getFilterCriteria(), searchDTO));
            } else if (dataType == SearchFieldDataTypeEnum.BIG_DECIMAL) {
                params.put(PARAM + field.getColOrder(), QueryHelper.parseBigDecimal(field.getFilterCriteria(), searchDTO));
            } else if (dataType == SearchFieldDataTypeEnum.INTEGER) {
                params.put(PARAM + field.getColOrder(), Integer.parseInt(field.getFilterCriteria()));
            } else if (dataType == SearchFieldDataTypeEnum.LONG) {
                params.put(PARAM + field.getColOrder(), Long.parseLong(field.getFilterCriteria()));
            }
        }
    }

    public static String createCountStatement(SearchDTO searchDTO) {
        StringBuffer statement = new StringBuffer(SELECT);
        boolean whereSet = false;
        try {
            statement.append(COUNT);
            statement.append(searchDTO.getFromClause());
            if (searchDTO.getFromClause().indexOf(WHERE) != -1) {
                whereSet = true;
            }
            for (SearchFieldDTO field : searchDTO.getSearchFields()) {
                if (field.getOperator() == null && (field.getFilterCriteria() == null || field.getFilterCriteria().isEmpty())) continue;
                statement.append(QueryHelper.addField(field, whereSet, searchDTO.isCaseSensitive(), searchDTO.isExactFilterMatch()));
                whereSet = true;
            }
            if (searchDTO.getGroupBy() != null && !searchDTO.getGroupBy().isEmpty()) {
                statement.append(searchDTO.getGroupBy());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return statement.toString();
    }
}

