/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.property;

import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import net.sourceforge.jbizmo.commons.property.IllegalPropertyValueException;

public class PropertyService {
    public static final String PROP_LOGGING_LEVEL = "logging_level";
    public static final String PROP_EXCHANGE_FOLDER = "exchange_folder";
    public static final String PROP_REPOSITORY_FOLDER = "document_repository_folder";
    private static boolean propertiesLoaded = false;
    private static Properties properties = null;
    private static final String PROPERTY_LOCATION = "config/application.properties";
    private static final String DATE_FORMAT = "dd.MM.yyyy HH:mm:ss";
    private static final String DECIMAL_FORMAT = "0.00";
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static DecimalFormat decimalFormat = new DecimalFormat("0.00");

    private PropertyService() {
    }

    private static String getProperty(String name) throws IllegalPropertyValueException {
        if (!propertiesLoaded) {
            PropertyService.loadProperties();
        }
        if (properties.getProperty(name) == null) {
            throw new IllegalPropertyValueException("Property " + name + " does not exist!");
        }
        return properties.getProperty(name);
    }

    public static String getStringProperty(String name) throws IllegalPropertyValueException {
        return PropertyService.getProperty(name);
    }

    public static int getIntProperty(String name) throws IllegalPropertyValueException {
        String propertyValue = PropertyService.getProperty(name);
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid integer value!");
        }
    }

    public static long getLongProperty(String name) throws IllegalPropertyValueException {
        String propertyValue = PropertyService.getProperty(name);
        try {
            return Long.parseLong(propertyValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid long value!");
        }
    }

    public static double getDoubleProperty(String name) throws IllegalPropertyValueException {
        String propertyValue = PropertyService.getProperty(name);
        try {
            Number n = decimalFormat.parse(propertyValue);
            return n.doubleValue();
        }
        catch (ParseException e) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid double value!");
        }
    }

    public static float getFloatProperty(String name) throws IllegalPropertyValueException {
        String propertyValue = PropertyService.getProperty(name);
        try {
            Number n = decimalFormat.parse(propertyValue);
            return n.floatValue();
        }
        catch (ParseException e) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid float value!");
        }
    }

    public static char getCharProperty(String name) throws IllegalPropertyValueException {
        String propertyValue = PropertyService.getProperty(name);
        if (propertyValue.isEmpty() || propertyValue.length() > 1) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid character value!");
        }
        return propertyValue.charAt(0);
    }

    public static synchronized Date getDateProperty(String name) throws IllegalPropertyValueException {
        String propertyValue = PropertyService.getProperty(name);
        try {
            return dateFormat.parse(propertyValue);
        }
        catch (ParseException e) {
            throw new IllegalPropertyValueException("Property " + name + " does not represent a valid java.util.Date value!");
        }
    }

    public static boolean getBooleanProperty(String name) throws IllegalPropertyValueException {
        String propertyValue = PropertyService.getProperty(name);
        return Boolean.parseBoolean(propertyValue);
    }

    private static synchronized void loadProperties() {
        InputStream in = PropertyService.class.getClassLoader().getResourceAsStream(PROPERTY_LOCATION);
        if (in == null) {
            return;
        }
        properties = new Properties();
        try {
            properties.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        propertiesLoaded = true;
    }
}

