/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.file;

import java.text.DecimalFormat;

public class ByteConverter {
    private static final short KB_EXPONENT = 10;
    private static final short MB_EXPONENT = 20;
    private static final short GB_EXPONENT = 30;

    public static String convert(long numberOfBytes) {
        DecimalFormat dc = new DecimalFormat(".00");
        double size = (double)numberOfBytes / Math.pow(2.0, 30.0);
        if (size > 1.0) {
            return dc.format(size) + " GB";
        }
        size = (double)numberOfBytes / Math.pow(2.0, 20.0);
        if (size > 1.0) {
            return dc.format(size) + " MB";
        }
        size = (double)numberOfBytes / Math.pow(2.0, 10.0);
        if (size > 1.0) {
            return dc.format(size) + " kB";
        }
        return numberOfBytes + " Bytes";
    }
}

