/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.crypto;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashGenerator {
    private static final String MD5 = "MD5";
    private static final String SHA256 = "SHA-256";
    private static final String CHARACTER_ENCODING = "UTF-8";

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static String encryptMD5(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return HashGenerator.encrypt(text, MD5, CHARACTER_ENCODING);
    }

    public static String encryptSHA256(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return HashGenerator.encrypt(text, SHA256, CHARACTER_ENCODING);
    }

    public static String encrypt(String text, String digester, String charEncoding) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance(digester);
        md.update(text.getBytes(charEncoding), 0, text.length());
        return HashGenerator.convertToHex(md.digest());
    }
}

