/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.reflect;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;

public class MethodFinder {
    private MethodFinder() {
    }

    public static Method findMethod(Class<?> cl, String methodName, Object[] params) throws NoSuchMethodException {
        Hashtable<String, Vector<Method>> methodHash = new Hashtable<String, Vector<Method>>();
        Hashtable<Method, Class<?>[]> paramHash = new Hashtable<Method, Class<?>[]>();
        Method[] methods = cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String mName = methods[i].getName();
            Vector<Method> v = (Vector<Method>)methodHash.get(mName);
            if (v == null) {
                v = new Vector<Method>();
                methodHash.put(mName, v);
            }
            v.addElement(methods[i]);
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            paramHash.put(methods[i], paramTypes);
        }
        Vector v = (Vector)methodHash.get(methodName);
        if (v == null) {
            throw new NoSuchMethodException(methodName);
        }
        for (int i = 0; i < v.size(); ++i) {
            Method m = (Method)v.elementAt(i);
            boolean ok = true;
            Class[] paramTypes = (Class[])paramHash.get(m);
            if (params == null) {
                params = new Object[]{};
            }
            if (paramTypes.length != params.length) continue;
            for (int j = 0; j < paramTypes.length; ++j) {
                if (params[j] == null) continue;
                Class<?> c = params[j].getClass();
                Class paramClass = paramTypes[j];
                if (paramClass.isPrimitive()) {
                    if (paramClass.equals(Integer.TYPE)) {
                        if (c.equals(Integer.class)) continue;
                        ok = false;
                        break;
                    }
                    if (paramClass.equals(Double.TYPE)) {
                        if (c.equals(Double.class)) continue;
                        ok = false;
                        break;
                    }
                    if (paramClass.equals(Boolean.TYPE)) {
                        if (c.equals(Boolean.class)) continue;
                        ok = false;
                        break;
                    }
                    if (paramClass.equals(Long.TYPE)) {
                        if (c.equals(Long.class)) continue;
                        ok = false;
                        break;
                    }
                    if (paramClass.equals(Character.TYPE)) {
                        if (c.equals(Character.class)) continue;
                        ok = false;
                        break;
                    }
                    if (paramClass.equals(Byte.TYPE)) {
                        if (c.equals(Byte.class)) continue;
                        ok = false;
                        break;
                    }
                    if (paramClass.equals(Float.TYPE)) {
                        if (c.equals(Float.class)) continue;
                        ok = false;
                        break;
                    }
                    if (!paramClass.equals(Short.TYPE)) break;
                    if (c.equals(Short.class)) continue;
                    ok = false;
                    break;
                }
                if (paramClass.isAssignableFrom(c)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return m;
        }
        throw new NoSuchMethodException(methodName);
    }
}

